/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatExpIntExp
extends FloatExpImpl {
    private static final int[] event_map = new int[]{2, 2, 4, 4, 1, 1, 8, 8};
    private static final boolean AS_FLOAT_EXP = true;
    private IntExp _exp;
    private ExpressionObserver _observer;

    public FloatExpIntExp(IntExp exp) {
        super(exp.constrainer(), exp.name());
        this._exp = exp;
        this._observer = new FloatExpIntExpObserver();
        this._exp.attachObserver(this._observer);
    }

    public boolean bound() {
        return super.bound();
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp.calcCoeffs(map, factor);
    }

    public boolean isLinear() {
        return this._exp.isLinear();
    }

    public double max() {
        return this._exp.max();
    }

    public double min() {
        return this._exp.min();
    }

    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    public void setMax(double max) throws Failure {
        if (max >= (double)this._exp.max()) {
            return;
        }
        if (max < (double)this._exp.min()) {
            this.constrainer().fail("FloatExpIntExp.setMax()");
        }
        int maxI = (int)Math.floor(max);
        this._exp.setMax(maxI);
    }

    public void setMin(double min) throws Failure {
        if (min <= (double)this._exp.min()) {
            return;
        }
        if (min > (double)this._exp.max()) {
            this.constrainer().fail("FloatExpIntExp.setMin()");
        }
        int minI = (int)Math.ceil(min);
        this._exp.setMin(minI);
    }

    public void setValue(double value) throws Failure {
        int valueI = (int)value;
        if ((double)valueI == value) {
            this._exp.setValue(valueI);
        } else {
            this.constrainer().fail("FloatExpIntExp.setValue(): bad integer value: " + value);
        }
    }

    public String toString() {
        return "Float(" + this._exp + ")";
    }

    public double value() throws Failure {
        return super.value();
    }

    class FloatExpIntExpObserver
    extends ExpressionObserver {
        FloatExpIntExpObserver() {
            super(event_map);
        }

        public Object master() {
            return FloatExpIntExp.this;
        }

        public String toString() {
            return "FloatExpIntExpObserver: ";
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            FloatEventIntEvent ev = FloatEventIntEvent.getEvent(e, FloatExpIntExp.this);
            FloatExpIntExp.this.notifyObservers(ev);
        }
    }

    static final class FloatEventIntEvent
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new FloatEventIntEvent();
            }
        };
        IntEvent _event;

        FloatEventIntEvent() {
        }

        static FloatEventIntEvent getEvent(IntEvent event, FloatExp exp) {
            FloatEventIntEvent ev = (FloatEventIntEvent)_factory.getElement();
            ev.init(event, exp);
            return ev;
        }

        public void init(IntEvent e, FloatExp exp_) {
            this.exp(exp_);
            this._event = e;
        }

        public double max() {
            return this._event.max();
        }

        public double min() {
            return this._event.min();
        }

        public String name() {
            return "Event FloatEventIntEvent";
        }

        public double oldmax() {
            return this._event.oldmax();
        }

        public double oldmin() {
            return this._event.oldmin();
        }

        public int type() {
            return this._event.type();
        }
    }
}

