/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class IntExpAddValue
extends IntExpImpl {
    private IntExp _exp;
    private int _value;
    private ExpressionObserver _observer;

    public IntExpAddValue(IntExp exp, int value) {
        super(exp.constrainer());
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp.name() + "+" + value + ")";
        }
        this._exp = exp;
        this._value = value;
        this._observer = new ExpAddValueObserver(this);
        this._exp.attachObserver(this._observer);
    }

    public IntExp add(int value) {
        return this._exp.add(this._value + value);
    }

    public boolean bound() {
        return this._exp.bound();
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp.calcCoeffs(map, factor) + (double)this._value * factor;
    }

    public boolean contains(int value) {
        return this._exp.contains(value - this._value);
    }

    public boolean isLinear() {
        return this._exp.isLinear();
    }

    public int max() {
        return this._exp.max() + this._value;
    }

    public int min() {
        return this._exp.min() + this._value;
    }

    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    public void removeValue(int value) throws Failure {
        this._exp.removeValue(value - this._value);
    }

    public void setMax(int max) throws Failure {
        this._exp.setMax(max - this._value);
    }

    public void setMin(int min) throws Failure {
        this._exp.setMin(min - this._value);
    }

    public void setValue(int value) throws Failure {
        this._exp.setValue(value - this._value);
    }

    public int size() {
        return this._exp.size();
    }

    public int value() throws Failure {
        if (!this._exp.bound()) {
            this.constrainer().fail("Attempt to get value of the unbound expression " + this);
        }
        return this._exp.value() + this._value;
    }

    static final class IntEventAddValue
    extends IntEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new IntEventAddValue();
            }
        };
        int _value;
        IntEvent _event;

        IntEventAddValue() {
        }

        static IntEventAddValue getEvent(IntEvent event, int value) {
            IntEventAddValue ev = (IntEventAddValue)_factory.getElement();
            ev.init(event, value);
            return ev;
        }

        public void init(IntEvent e, int value) {
            this._event = e;
            this._value = value;
        }

        public int max() {
            return this._event.max() + this._value;
        }

        public int min() {
            return this._event.min() + this._value;
        }

        public String name() {
            return "Event AddValue";
        }

        public int numberOfRemoves() {
            return this._event.numberOfRemoves();
        }

        public int oldmax() {
            return this._event.oldmax() + this._value;
        }

        public int oldmin() {
            return this._event.oldmin() + this._value;
        }

        public int removed(int i) {
            return this._event.removed(i) + this._value;
        }

        public int type() {
            return this._event.type();
        }
    }

    class ExpAddValueObserver
    extends ExpressionObserver {
        IntExp _exp_this;

        ExpAddValueObserver(IntExp exp_this) {
            this._exp_this = exp_this;
        }

        public Object master() {
            return IntExpAddValue.this;
        }

        public String toString() {
            return "ExpAddValueObserver: " + IntExpAddValue.this._exp + "+" + IntExpAddValue.this._value;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            IntEventAddValue ev = IntEventAddValue.getEvent(e, IntExpAddValue.this._value);
            ev.exp(this._exp_this);
            IntExpAddValue.this.notifyObservers(ev);
        }
    }
}

