/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Comparator;
import java.util.HashMap;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpEnum;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;
import org.openl.ie.tools.ReusableImpl;

public class IntExpArrayElement1
extends IntExpImpl {
    private IntExpArray _ary;
    private AryElementsObserver[] _aryElementsObservers = null;
    private IntExp _indexExp;
    private IntVar _index;
    private IntExp _element;
    private Mapping _m;

    static int findIndex(IntExp index, IntExpArray ary, int value) {
        FindValueIterator it = FindValueIterator.getIterator(index, ary, value);
        try {
            index.iterateDomain(it);
        }
        catch (Failure f) {
            // empty catch block
        }
        int foundIndex = it.foundIndex;
        it.free();
        return foundIndex;
    }

    static boolean indexHasValue(IntExp index, IntExpArray ary, int value) {
        return IntExpArrayElement1.findIndex(index, ary, value) >= 0;
    }

    static IntExpArray makeExtraction(IntExp index, IntExpArray ary) {
        CopyElementsIterator iter = CopyElementsIterator.getIterator(index, ary);
        try {
            index.iterateDomain(iter);
        }
        catch (Failure failure) {
            // empty catch block
        }
        return iter.extract;
    }

    public IntExpArrayElement1(IntExpArray ary, IntExp indexExp) {
        super(ary.constrainer());
        this._ary = ary;
        this._indexExp = indexExp;
        this._aryElementsObservers = new AryElementsObserver[ary.size()];
        if (this.constrainer().showInternalNames()) {
            this._name = "" + this._ary.name() + "[" + this._indexExp.name() + "]";
        }
        try {
            this.createIndex();
            this.createElement();
            this.constrainer().propagate();
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid elementAt-expression: " + ary + "[" + indexExp + "]. " + e.getClass().getName() + ": " + e.getMessage());
        }
        this.createMapping();
        this._index.attachObserver(new IndexObserver());
        this._element.attachObserver(new ElementObserver());
        for (int i = 0; i < this._ary.size(); ++i) {
            if (!this._index.contains(i)) continue;
            this._aryElementsObservers[i] = new AryElementsObserver(i);
            this._ary.get(i).attachObserver(this._aryElementsObservers[i]);
        }
    }

    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._element.attachObserver(observer);
    }

    public boolean contains(int value) {
        return this._element.contains(value);
    }

    void createElement() throws Failure {
        int size;
        int min;
        int[] values = this.elementDomain();
        int max = values[values.length - 1];
        int nHoles = max - (min = values[0]) + 1 - (size = values.length);
        if (nHoles < 10) {
            this.createElement1(values);
        } else {
            this.createElement2(values);
        }
    }

    void createElement1(int[] values) throws Failure {
        int trace = 0;
        int min = values[0];
        int max = values[values.length - 1];
        String name = "";
        if (this.constrainer().showInternalNames()) {
            name = "element_" + this._ary.name() + "[" + this._indexExp.name() + "]";
        }
        this._element = this.constrainer().addIntVarTraceInternal(min, max, name, 1, trace);
        int i = 0;
        while (i + 1 < values.length) {
            for (int value = values[i] + 1; value < values[i + 1] - 1; ++value) {
                this._element.removeValue(value);
            }
            ++i;
        }
    }

    void createElement2(int[] values) throws Failure {
        String name = "";
        if (this.constrainer().showInternalNames()) {
            name = "element_" + this._ary.name() + "[" + this._indexExp.name() + "]";
        }
        this._element = new IntExpEnum(this.constrainer(), values, name);
    }

    void createIndex() throws Failure {
        boolean effectiveIndexExp = this._indexExp instanceof IntVar && ((IntVar)this._indexExp).domainType() != 0;
        int max = this._ary.size() - 1;
        if (effectiveIndexExp) {
            this._index = (IntVar)this._indexExp;
            this._index.setMin(0);
            this._index.setMax(max);
        } else {
            int trace = 0;
            String name = "";
            if (this.constrainer().showInternalNames()) {
                name = "index_" + this._ary.name() + "[" + this._indexExp.name() + "]";
            }
            this._index = this.constrainer().addIntVarTraceInternal(0, max, name, 1, trace);
            for (int i = 0; i <= max; ++i) {
                if (this._indexExp.contains(i)) continue;
                this._index.removeValue(i);
            }
            this._index.equals(this._indexExp).post();
        }
    }

    void createMapping() {
        this._m = new AdvancedMapping2(this._index, this._element, this._ary, this._aryElementsObservers);
    }

    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._element.detachObserver(observer);
    }

    public String domainToString() {
        return this._element.domainToString();
    }

    int[] elementDomain() {
        int i;
        int arMin = this._ary.min();
        int arMax = this._ary.max();
        int[] values = new int[arMax - arMin + 1];
        int valCounter = 0;
        IntExpArray tmp = IntExpArrayElement1.makeExtraction(this._index, this._ary);
        class IntExpComparator
        implements Comparator {
            IntExpComparator() {
            }

            public int compare(Object a1, Object a2) {
                if (((IntExp)a1).min() < ((IntExp)a2).min()) {
                    return -1;
                }
                if (((IntExp)a1).min() == ((IntExp)a2).min()) {
                    return 0;
                }
                return 1;
            }
        }
        tmp.sort(new IntExpComparator());
        for (i = tmp.get(0).min(); i <= tmp.get(0).max(); ++i) {
            if (!tmp.get(0).contains(i)) continue;
            values[valCounter++] = i;
        }
        for (i = 1; i < tmp.size(); ++i) {
            IntExp curElem = tmp.get(i);
            int min = curElem.min();
            int max = curElem.max();
            if (min < values[valCounter - 1]) {
                min = values[valCounter - 1] + 1;
            }
            for (int j = min; j <= max; ++j) {
                if (!curElem.contains(j)) continue;
                values[valCounter++] = j;
            }
        }
        int[] valFinally = new int[valCounter];
        System.arraycopy(values, 0, valFinally, 0, valCounter);
        return valFinally;
    }

    public int max() {
        return this._element.max();
    }

    public int min() {
        return this._element.min();
    }

    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._element.reattachObserver(observer);
    }

    public void removeValue(int value) throws Failure {
        this._element.removeValue(value);
    }

    public void setMax(int max) throws Failure {
        this._element.setMax(max);
    }

    public void setMin(int min) throws Failure {
        this._element.setMin(min);
    }

    public void setValue(int value) throws Failure {
        this._element.setValue(value);
    }

    public int size() {
        return this._element.size();
    }

    private static class ValueCounterIterator
    implements IntExp.IntDomainIterator {
        IntExpArray _ary;
        int _val;
        int cnt = 0;

        public ValueCounterIterator(IntExpArray array, int value) {
            this._ary = array;
            this._val = value;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            if (this._ary.get(idx).contains(this._val)) {
                ++this.cnt;
            }
            return true;
        }
    }

    static class SimpleMapping
    implements Mapping {
        IntExp _index;
        IntExp _element;
        IntExpArray _ary;
        AryElementsObserver[] _observers;

        public SimpleMapping(IntExp index, IntExp element, IntExpArray ary, AryElementsObserver[] observers) {
            this._index = index;
            this._element = element;
            this._ary = ary;
            this._observers = observers;
        }

        public void arrayElementMax(int oldmax, int max, int idx) throws Failure {
            if (this._element.min() > max) {
                this._index.removeValue(idx);
            }
        }

        public void arrayElementMin(int oldmin, int min, int idx) throws Failure {
            if (this._element.max() < min) {
                this._index.removeValue(idx);
            }
        }

        public void arrayElementRemove(int value, int idx) throws Failure {
        }

        public void arrayElementValue(int value, int idx) throws Failure {
            if (value > this._element.max() || value < this._element.min()) {
                this._index.removeValue(idx);
            }
        }

        public void indexMax(int oldmax, int max) throws Failure {
            for (int i = oldmax; i > max; --i) {
                if (this._observers[i] == null) continue;
                this._ary.get(i).detachObserver(this._observers[i]);
            }
            this.updateResultDomainFromIndex();
        }

        public void indexMin(int oldmin, int min) throws Failure {
            for (int i = oldmin; i < min; ++i) {
                if (this._observers[i] == null) continue;
                this._ary.get(i).detachObserver(this._observers[i]);
            }
            this.updateResultDomainFromIndex();
        }

        public void indexRemove(int value) throws Failure {
            this._ary.get(value).detachObserver(this._observers[value]);
        }

        public void indexValue(int value) throws Failure {
            for (int i = 0; i < this._ary.size(); ++i) {
                if (this._observers[i] == null || i == value) continue;
                this._ary.get(value).detachObserver(this._observers[i]);
            }
            this._element.setMin(this._ary.get(value).min());
            this._element.setMax(this._ary.get(value).max());
        }

        public void resultMax(int max) throws Failure {
            RemoveFromElementMaxIterator it = RemoveFromElementMaxIterator.getIterator(this._index, this._ary, max);
            this._index.iterateDomain(it);
            it.free();
        }

        public void resultMin(int min) throws Failure {
            RemoveFromElementMinIterator it = RemoveFromElementMinIterator.getIterator(this._index, this._ary, min);
            this._index.iterateDomain(it);
            it.free();
        }

        public void resultRemove(int value) throws Failure {
        }

        public void resultValue(int value) throws Failure {
            SetValueFromElementIterator it = SetValueFromElementIterator.getIterator(this._index, this._ary, value);
            this._index.iterateDomain(it);
            it.free();
        }

        public void updateResultDomainFromIndex() throws Failure {
            FindMinMaxIterator it = FindMinMaxIterator.getIterator(this._index, this._ary);
            this._index.iterateDomain(it);
            this._element.setMin(it.min);
            this._element.setMax(it.max);
            it.free();
        }
    }

    static class SetValueFromElementIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new SetValueFromElementIterator();
            }
        };
        IntExp index;
        IntExpArray ary;
        int value;

        SetValueFromElementIterator() {
        }

        static SetValueFromElementIterator getIterator(IntExp index, IntExpArray ary, int value) {
            SetValueFromElementIterator it = (SetValueFromElementIterator)_factory.getElement();
            it.index = index;
            it.ary = ary;
            it.value = value;
            return it;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            if (!this.ary.elementAt(idx).contains(this.value)) {
                this.index.removeValue(idx);
            }
            return true;
        }
    }

    static class RemoveFromElementMinIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new RemoveFromElementMinIterator();
            }
        };
        IntExp index;
        IntExpArray ary;
        int min;

        RemoveFromElementMinIterator() {
        }

        static RemoveFromElementMinIterator getIterator(IntExp index, IntExpArray ary, int min) {
            RemoveFromElementMinIterator it = (RemoveFromElementMinIterator)_factory.getElement();
            it.index = index;
            it.ary = ary;
            it.min = min;
            return it;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            int arrayElementMax = this.ary.elementAt(idx).max();
            if (this.min > arrayElementMax) {
                this.index.removeValue(idx);
            }
            return true;
        }
    }

    static class RemoveFromElementMaxIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new RemoveFromElementMaxIterator();
            }
        };
        IntExp index;
        IntExpArray ary;
        int max;

        RemoveFromElementMaxIterator() {
        }

        static RemoveFromElementMaxIterator getIterator(IntExp index, IntExpArray ary, int max) {
            RemoveFromElementMaxIterator it = (RemoveFromElementMaxIterator)_factory.getElement();
            it.index = index;
            it.ary = ary;
            it.max = max;
            return it;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            int arrayElementMin = this.ary.elementAt(idx).min();
            if (this.max < arrayElementMin) {
                this.index.removeValue(idx);
            }
            return true;
        }
    }

    static interface Mapping {
        public void arrayElementMax(int var1, int var2, int var3) throws Failure;

        public void arrayElementMin(int var1, int var2, int var3) throws Failure;

        public void arrayElementRemove(int var1, int var2) throws Failure;

        public void arrayElementValue(int var1, int var2) throws Failure;

        public void indexMax(int var1, int var2) throws Failure;

        public void indexMin(int var1, int var2) throws Failure;

        public void indexRemove(int var1) throws Failure;

        public void indexValue(int var1) throws Failure;

        public void resultMax(int var1) throws Failure;

        public void resultMin(int var1) throws Failure;

        public void resultRemove(int var1) throws Failure;

        public void resultValue(int var1) throws Failure;
    }

    class IndexObserver
    extends Observer {
        IndexObserver() {
        }

        public Object master() {
            return IntExpArrayElement1.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            int type = e.type();
            if ((type & 1) != 0) {
                IntExpArrayElement1.this._m.indexValue(e.min());
            } else {
                if ((type & 2) != 0) {
                    IntExpArrayElement1.this._m.indexMin(e.oldmin(), e.min());
                }
                if ((type & 4) != 0) {
                    IntExpArrayElement1.this._m.indexMax(e.oldmax(), e.max());
                }
                if ((type & 8) != 0) {
                    int nRemoves = e.numberOfRemoves();
                    int min = e.min();
                    int max = e.max();
                    for (int i = 0; i < nRemoves; ++i) {
                        int removedValue = e.removed(i);
                        if (min > removedValue || removedValue > max) continue;
                        IntExpArrayElement1.this._m.indexRemove(removedValue);
                    }
                }
            }
        }
    }

    static class FindValueIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new FindValueIterator();
            }
        };
        IntExp index;
        IntExpArray ary;
        int value;
        int foundIndex;

        FindValueIterator() {
        }

        static FindValueIterator getIterator(IntExp index, IntExpArray ary, int value) {
            FindValueIterator it = (FindValueIterator)_factory.getElement();
            it.index = index;
            it.ary = ary;
            it.value = value;
            it.foundIndex = -1;
            return it;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            if (this.ary.elementAt(idx).contains(this.value)) {
                this.foundIndex = idx;
                return false;
            }
            return true;
        }
    }

    static class FindMinMaxIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new FindMinMaxIterator();
            }
        };
        IntExpArray ary;
        int min = Integer.MAX_VALUE;
        int max = -2147483647;
        IntExp index;

        FindMinMaxIterator() {
        }

        static FindMinMaxIterator getIterator(IntExp index, IntExpArray ary) {
            FindMinMaxIterator it = (FindMinMaxIterator)_factory.getElement();
            it.index = index;
            it.ary = ary;
            return it;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            if (this.ary.elementAt(idx).max() > this.max) {
                this.max = this.ary.elementAt(idx).max();
            }
            if (this.ary.elementAt(idx).min() < this.min) {
                this.min = this.ary.elementAt(idx).min();
            }
            return true;
        }
    }

    class ElementObserver
    extends Observer {
        ElementObserver() {
        }

        public Object master() {
            return IntExpArrayElement1.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            int type = e.type();
            if ((type & 1) != 0) {
                IntExpArrayElement1.this._m.resultValue(e.min());
            } else {
                if ((type & 2) != 0) {
                    IntExpArrayElement1.this._m.resultMin(e.min());
                }
                if ((type & 4) != 0) {
                    IntExpArrayElement1.this._m.resultMax(e.max());
                }
                if ((type & 8) != 0) {
                    int nRemoves = e.numberOfRemoves();
                    int min = e.min();
                    int max = e.max();
                    for (int i = 0; i < nRemoves; ++i) {
                        int removedValue = e.removed(i);
                        if (min > removedValue || removedValue > max) continue;
                        IntExpArrayElement1.this._m.resultRemove(removedValue);
                    }
                }
            }
        }
    }

    static class CopyElementsIterator
    extends ReusableImpl
    implements IntExp.IntDomainIterator {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new CopyElementsIterator();
            }
        };
        IntExp _index;
        IntExpArray source;
        IntExpArray extract;
        int cnt = 0;

        CopyElementsIterator() {
        }

        static CopyElementsIterator getIterator(IntExp index, IntExpArray ary) {
            CopyElementsIterator iter = new CopyElementsIterator();
            iter._index = index;
            iter.source = ary;
            iter.extract = new IntExpArray(index.constrainer(), index.size());
            return iter;
        }

        public boolean doSomethingOrStop(int idx) throws Failure {
            this.extract.set(this.source.get(idx), this.cnt++);
            return true;
        }
    }

    class AryElementsObserver
    extends Observer {
        private int idx;

        public AryElementsObserver(int id) {
            this.idx = id;
        }

        public Object master() {
            return IntExpArrayElement1.this;
        }

        public int subscriberMask() {
            return 15;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            int type = e.type();
            if ((type & 1) != 0) {
                int value = e.min();
                IntExpArrayElement1.this._m.arrayElementValue(value, this.idx);
            } else {
                if ((type & 2) != 0) {
                    IntExpArrayElement1.this._m.arrayElementMin(e.oldmin(), e.min(), this.idx);
                }
                if ((type & 4) != 0) {
                    IntExpArrayElement1.this._m.arrayElementMax(e.oldmax(), e.max(), this.idx);
                }
                if ((type & 8) != 0) {
                    int nRemoves = e.numberOfRemoves();
                    int min = e.min();
                    int max = e.max();
                    for (int i = 0; i < nRemoves; ++i) {
                        int removedValue = e.removed(i);
                        if (min > removedValue || removedValue > max) continue;
                        IntExpArrayElement1.this._m.arrayElementRemove(removedValue, this.idx);
                    }
                }
            }
        }
    }

    static class AdvancedMapping2
    extends AdvancedMapping {
        public AdvancedMapping2(IntExp index, IntExp element, IntExpArray ary, AryElementsObserver[] observers) {
            super(index, element, ary, observers);
        }

        public void indexMax(int oldmax, int max) throws Failure {
            this.updateResultDomainFromIndex();
            this.detachObservers(max + 1, oldmax);
            this._copyOfIndex.setMax(max);
        }

        public void indexMin(int oldmin, int min) throws Failure {
            this.updateResultDomainFromIndex();
            this.detachObservers(oldmin, min - 1);
            this._copyOfIndex.setMin(min);
        }

        public void indexRemove(int removedValue) throws Failure {
            this.updateResultDomainFromIndex();
            this.detachObservers(removedValue, removedValue);
            this._copyOfIndex.removeValue(removedValue);
        }
    }

    static class AdvancedMapping
    implements Mapping {
        HashMap valueToArrayIdx = new HashMap();
        IntExp _index;
        IntExp _element;
        IntExpArray _ary;
        IntExpArray _valuesUsed;
        IntExpArray copyOfAry;
        IntExp _copyOfIndex;
        AryElementsObserver[] _observers;

        static IntExpArray createCopyOfIntExpArray(IntExpArray array) {
            IntExpArray arrCopy = new IntExpArray(array.constrainer(), array.size());
            for (int i = 0; i < array.size(); ++i) {
                IntExp exp = array.get(i);
                IntVar varCopy = exp instanceof IntVar ? AdvancedMapping.createCopyOfIntVar((IntVar)exp) : array.constrainer().addIntVar(exp.min(), exp.max(), 0);
                arrCopy.set(varCopy, i);
            }
            return arrCopy;
        }

        static IntVar createCopyOfIntVar(IntVar var) {
            int type = var.domainType();
            boolean remove = false;
            switch (type) {
                case 1: 
                case 2: {
                    remove = true;
                }
            }
            IntVar copy = var.constrainer().addIntVar(var.min(), var.max(), type);
            if (remove) {
                for (int i = var.min(); i <= var.max(); ++i) {
                    if (var.contains(i)) continue;
                    try {
                        copy.removeValue(i);
                        continue;
                    }
                    catch (Failure f) {
                        // empty catch block
                    }
                }
            }
            return copy;
        }

        public AdvancedMapping(IntExp index, IntExp element, IntExpArray ary, AryElementsObserver[] observers) {
            this._observers = observers;
            this._index = index;
            this._element = element;
            this._ary = ary;
            this.createCountersArray();
            this._copyOfIndex = AdvancedMapping.createCopyOfIntVar((IntVar)this._index);
            this.copyOfAry = AdvancedMapping.createCopyOfIntExpArray(this._ary);
        }

        public void arrayElementMax(int oldmax, int max, int idx) throws Failure {
            if (max < this._element.min()) {
                this._index.removeValue(idx);
            } else {
                this.decreaseUsageCounter(max + 1, oldmax, idx);
            }
            IntVar varCopy = (IntVar)this.copyOfAry.get(idx);
            varCopy.setMax(max);
        }

        public void arrayElementMin(int oldmin, int min, int idx) throws Failure {
            if (min > this._element.max()) {
                this._index.removeValue(idx);
            } else {
                this.decreaseUsageCounter(oldmin, min - 1, idx);
            }
            IntVar varCopy = (IntVar)this.copyOfAry.get(idx);
            varCopy.setMin(min);
        }

        public void arrayElementRemove(int removedValue, int idx) throws Failure {
            this.decreaseUsageCounter(removedValue);
            IntVar varCopy = (IntVar)this.copyOfAry.get(idx);
            varCopy.removeValue(removedValue);
        }

        public void arrayElementValue(int value, int idx) throws Failure {
            IntVar varCopy = (IntVar)this.copyOfAry.get(idx);
            if (value < this._element.min() || value > this._element.max()) {
                this._index.removeValue(idx);
            } else {
                int i;
                for (i = varCopy.min(); i < value; ++i) {
                    if (!varCopy.contains(i)) continue;
                    this.decreaseUsageCounter(i);
                }
                for (i = varCopy.max(); i > value; --i) {
                    if (!varCopy.contains(i)) continue;
                    this.decreaseUsageCounter(i);
                }
            }
            varCopy.setValue(value);
        }

        void createCountersArray() {
            int i;
            int cnt = 0;
            int[] usage = new int[this._element.size()];
            for (i = this._element.min(); i <= this._element.max(); ++i) {
                if (!this._element.contains(i)) continue;
                ValueCounterIterator iter = new ValueCounterIterator(this._ary, i);
                try {
                    this._index.iterateDomain(iter);
                }
                catch (Failure f) {
                    // empty catch block
                }
                this.valueToArrayIdx.put(new Integer(i), new Integer(cnt));
                usage[cnt] = iter.cnt;
                ++cnt;
            }
            this._valuesUsed = new IntExpArray(this._index.constrainer(), cnt);
            for (i = 0; i < cnt; ++i) {
                this._valuesUsed.set(this._index.constrainer().addIntVar(0, usage[i]), i);
            }
        }

        void decreaseUsageCounter(int val) throws Failure {
            int idx = (Integer)this.valueToArrayIdx.get(new Integer(val));
            int oldMax = this._valuesUsed.get(idx).max();
            if (oldMax == 1) {
                this._element.removeValue(val);
                this._valuesUsed.get(idx).setMax(0);
            } else {
                this._valuesUsed.get(idx).setMax(oldMax - 1);
            }
        }

        void decreaseUsageCounter(int start, int end, int idx) throws Failure {
            IntVar var = (IntVar)this.copyOfAry.get(idx);
            for (int i = start; i <= end; ++i) {
                if (!var.contains(i)) continue;
                this.decreaseUsageCounter(i);
            }
        }

        void detachObservers(int start, int end) {
            for (int i = start; i <= end; ++i) {
                if (!this._copyOfIndex.contains(i)) continue;
                this._ary.get(i).detachObserver(this._observers[i]);
            }
        }

        public void indexMax(int oldmax, int max) throws Failure {
            FindMinMaxIterator iter = FindMinMaxIterator.getIterator(this._index, this._ary);
            this._index.iterateDomain(iter);
            if (iter.max < this._element.max() && iter.min > this._element.min()) {
                this._element.setMax(iter.max);
                this._element.setMin(iter.min);
            } else {
                for (int i = oldmax; i > max; --i) {
                    if (!this._copyOfIndex.contains(i)) continue;
                    this.decreaseUsageCounter(this.copyOfAry.get(i).min(), this.copyOfAry.get(i).max(), i);
                }
            }
            this.detachObservers(max + 1, oldmax);
            this._copyOfIndex.setMax(max);
        }

        public void indexMin(int oldmin, int min) throws Failure {
            FindMinMaxIterator iter = FindMinMaxIterator.getIterator(this._index, this._ary);
            this._index.iterateDomain(iter);
            if (iter.max < this._element.max() || iter.min > this._element.min()) {
                this._element.setMax(iter.max);
                this._element.setMin(iter.min);
            } else {
                for (int i = oldmin; i < min; ++i) {
                    if (!this._copyOfIndex.contains(i)) continue;
                    this.decreaseUsageCounter(this.copyOfAry.get(i).min(), this.copyOfAry.get(i).max(), i);
                }
            }
            this.updateResultDomainFromIndex();
            this.detachObservers(oldmin, min - 1);
            this._copyOfIndex.setMin(min);
        }

        public void indexRemove(int removedValue) throws Failure {
            if (this._copyOfIndex.contains(removedValue)) {
                this.decreaseUsageCounter(this.copyOfAry.get(removedValue).min(), this.copyOfAry.get(removedValue).max(), removedValue);
            }
            this._ary.get(removedValue).detachObserver(this._observers[removedValue]);
            this._copyOfIndex.removeValue(removedValue);
        }

        public void indexValue(int value) throws Failure {
            this._element.setMin(this._ary.get(value).min());
            this._element.setMax(this._ary.get(value).max());
            for (int i = 0; i < this._ary.size(); ++i) {
                if (!this._copyOfIndex.contains(i) || i == value) continue;
                this._ary.get(i).detachObserver(this._observers[i]);
            }
            this._copyOfIndex.setValue(value);
        }

        public void resultMax(int max) throws Failure {
            RemoveFromElementMaxIterator it = RemoveFromElementMaxIterator.getIterator(this._index, this._ary, max);
            this._index.iterateDomain(it);
            it.free();
        }

        public void resultMin(int min) throws Failure {
            RemoveFromElementMinIterator it = RemoveFromElementMinIterator.getIterator(this._index, this._ary, min);
            this._index.iterateDomain(it);
            it.free();
        }

        public void resultRemove(int value) throws Failure {
        }

        public void resultValue(int value) throws Failure {
            SetValueFromElementIterator it = SetValueFromElementIterator.getIterator(this._index, this._ary, value);
            this._index.iterateDomain(it);
            it.free();
        }

        void synchronizedUsageCounterWithIndex(int valueBeingSet) {
        }

        void updateResultDomainFromIndex() throws Failure {
            FindMinMaxIterator it = FindMinMaxIterator.getIterator(this._index, this._ary);
            this._index.iterateDomain(it);
            this._element.setMin(it.min);
            this._element.setMax(it.max);
            it.free();
        }
    }
}

