/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpMulExpPP
extends IntExpImpl {
    private IntExp _exp1;
    private IntExp _exp2;
    private Observer _observer;
    private IntVar _product;

    public IntExpMulExpPP(IntExp exp1, IntExp exp2) {
        super(exp1.constrainer());
        this._exp1 = exp1;
        this._exp2 = exp2;
        if (this.constrainer().showInternalNames()) {
            this._name = "(" + exp1.name() + "*" + exp2.name() + ")";
        }
        int trace = 0;
        this._product = this.constrainer().addIntVarTraceInternal(this.calc_min(), this.calc_max(), "mul", 0, trace);
        this._observer = new ExpMultiplyPositiveObserver();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._product.attachObserver(observer);
    }

    int calc_max() {
        return this._exp1.max() * this._exp2.max();
    }

    int calc_min() {
        return this._exp1.min() * this._exp2.min();
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        if (this._exp1.bound()) {
            return this._exp2.calcCoeffs(map, factor * (double)this._exp1.max());
        }
        if (this._exp2.bound()) {
            return this._exp1.calcCoeffs(map, factor * (double)this._exp2.max());
        }
        throw new NonLinearExpression(this);
    }

    public boolean contains(int value) {
        return super.contains(value);
    }

    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._product.detachObserver(observer);
    }

    public boolean isLinear() {
        if (!this._exp1.bound() && !this._exp2.bound()) {
            return false;
        }
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    public int max() {
        return this._product.max();
    }

    public int min() {
        return this._product.min();
    }

    public void onMaskChange() {
    }

    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._product.reattachObserver(observer);
    }

    public void removeValue(int value) throws Failure {
    }

    public void setMax(int max) throws Failure {
        int Max;
        int delta;
        int q;
        if (max >= this.max()) {
            return;
        }
        this._product.setMax(max);
        if (max < this.min()) {
            this.constrainer().fail("Mul PP Set Max");
        }
        int Pmax = max;
        int v = this._exp2.min();
        if (v != 0) {
            q = Pmax / v;
            delta = Pmax - q * v;
            Max = delta >= 0 ? q : q - 1;
            this._exp1.setMax(Max);
        }
        if ((v = this._exp1.min()) != 0) {
            q = Pmax / v;
            delta = Pmax - q * v;
            Max = delta >= 0 ? q : q - 1;
            this._exp2.setMax(Max);
        }
    }

    public void setMin(int min) throws Failure {
        int Min;
        int delta;
        int q;
        if (min <= this.min()) {
            return;
        }
        this._product.setMin(min);
        if (min > this.max()) {
            this.constrainer().fail("Mul PP Set Min");
        }
        int Pmin = min;
        int v = this._exp2.max();
        if (v != 0) {
            q = Pmin / v;
            delta = Pmin - q * v;
            Min = delta > 0 ? q + 1 : q;
            this._exp1.setMin(Min);
        }
        if ((v = this._exp1.max()) != 0) {
            q = Pmin / v;
            delta = Pmin - q * v;
            Min = delta > 0 ? q + 1 : q;
            this._exp2.setMin(Min);
        }
    }

    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    public int value() throws Failure {
        return this._product.value();
    }

    class ExpMultiplyPositiveObserver
    extends Observer {
        ExpMultiplyPositiveObserver() {
        }

        public Object master() {
            return IntExpMulExpPP.this;
        }

        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "ExpMulExpPPObserver: " + IntExpMulExpPP.this._exp1 + " x " + IntExpMulExpPP.this._exp2;
        }

        public void update(Subject subject, EventOfInterest event) throws Failure {
            int mask = event.type();
            if ((mask & 4) != 0) {
                IntExpMulExpPP.this._product.setMax(IntExpMulExpPP.this.calc_max());
            }
            if ((mask & 2) != 0) {
                IntExpMulExpPP.this._product.setMin(IntExpMulExpPP.this.calc_min());
            }
        }
    }
}

