/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntEvent;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class IntExpOpposite
extends IntExpImpl {
    private static final int[] event_map = new int[]{2, 4, 4, 2, 1, 1, 8, 8};
    private IntExp _exp;
    private ExpressionObserver _observer;

    public IntExpOpposite(IntExp exp) {
        super(exp.constrainer());
        if (this.constrainer().showInternalNames()) {
            this._name = "(-" + exp.name() + ")";
        }
        this._exp = exp;
        this._observer = new ExpOppositeObserver(this, event_map);
        this._exp.attachObserver(this._observer);
    }

    public boolean bound() {
        return this._exp.bound();
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp.calcCoeffs(map, -1.0 * factor);
    }

    public boolean contains(int value) {
        return this._exp.contains(-value);
    }

    public boolean isLinear() {
        return this._exp.isLinear();
    }

    public int max() {
        return -this._exp.min();
    }

    public int min() {
        return -this._exp.max();
    }

    public IntExp neg() {
        return this._exp;
    }

    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    public void removeValue(int value) throws Failure {
        this._exp.removeValue(-value);
    }

    public void setMax(int max) throws Failure {
        this._exp.setMin(-max);
    }

    public void setMin(int min) throws Failure {
        this._exp.setMax(-min);
    }

    public void setValue(int value) throws Failure {
        this._exp.setValue(-value);
    }

    public int size() {
        return this._exp.size();
    }

    public int value() throws Failure {
        if (!this._exp.bound()) {
            this.constrainer().fail("Attempt to get value of the unbound expression " + this);
        }
        return -this._exp.value();
    }

    static class IntEventOpposite
    extends IntEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new IntEventOpposite();
            }
        };
        IntEvent _event;
        int _type;

        IntEventOpposite() {
        }

        static IntEventOpposite getEvent(IntEvent event) {
            IntEventOpposite ev = (IntEventOpposite)_factory.getElement();
            ev.init(event);
            return ev;
        }

        public void init(IntEvent e) {
            int type;
            this._event = e;
            this._type = type = e.type();
            this._type |= 6;
            if ((type & 2) == 0) {
                this._type &= 0xFFFFFFFB;
            }
            if ((type & 4) == 0) {
                this._type &= 0xFFFFFFFD;
            }
        }

        public int max() {
            return -this._event.min();
        }

        public int min() {
            return -this._event.max();
        }

        public String name() {
            return "Event Opposite";
        }

        public int numberOfRemoves() {
            return this._event.numberOfRemoves();
        }

        public int oldmax() {
            return -this._event.oldmin();
        }

        public int oldmin() {
            return -this._event.oldmax();
        }

        public int removed(int i) {
            return -this._event.removed(i);
        }

        public int type() {
            return this._type;
        }
    }

    class ExpOppositeObserver
    extends ExpressionObserver {
        IntExp _exp_this;

        ExpOppositeObserver(IntExp exp_this, int[] event_map) {
            super(event_map);
            this._exp_this = exp_this;
        }

        public Object master() {
            return IntExpOpposite.this;
        }

        public String toString() {
            return "ExpOppositeObserver: " + IntExpOpposite.this._exp;
        }

        public void update(Subject exp, EventOfInterest event) throws Failure {
            IntEvent e = (IntEvent)event;
            IntEventOpposite ev = IntEventOpposite.getEvent(e);
            ev.exp(this._exp_this);
            IntExpOpposite.this.notifyObservers(ev);
        }
    }
}

