/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.IntExpImpl;

public final class IntExpPositive
extends IntExpImpl {
    private IntExp _exp;
    private ExpressionObserver _observer;

    public IntExpPositive(IntExp exp) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._observer = new ExpPositiveObserver();
        this._exp.attachObserver(this._observer);
    }

    public boolean contains(int value) {
        return value >= 0 && this._exp.contains(value);
    }

    public int max() {
        int max = this._exp.max();
        return max >= 0 ? max : -2147483647;
    }

    public int min() {
        int min = this._exp.min();
        return min > 0 ? min : 0;
    }

    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    public void removeValue(int value) throws Failure {
        if (value >= 0) {
            this._exp.removeValue(value);
        }
    }

    public void setMax(int max) throws Failure {
        this._exp.setMax(max);
    }

    public void setMin(int min) throws Failure {
        if (this._exp.min() >= 0) {
            this._exp.setMin(min);
        }
    }

    public void setValue(int value) throws Failure {
        this._exp.setValue(value);
    }

    public int size() {
        if (!this.valid()) {
            return 0;
        }
        return Math.min(this._exp.size(), this._exp.max() + 1);
    }

    public String toString() {
        return this._exp + "++";
    }

    public boolean valid() {
        return this._exp.min() >= 0;
    }

    public int value() throws Failure {
        if (!this.bound()) {
            this.constrainer().fail("Attempt to get value of the unbound expression " + this);
        }
        return this._exp.value();
    }

    class ExpPositiveObserver
    extends ExpressionObserver {
        ExpPositiveObserver() {
        }

        public Object master() {
            return IntExpPositive.this;
        }

        public String toString() {
            return "ExpPositiveObserver: " + IntExpPositive.this._exp;
        }

        public void update(Subject subject, EventOfInterest event) throws Failure {
        }
    }
}

