/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Domain;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalInstantiate;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.Undoable;
import org.openl.ie.constrainer.impl.DomainBits;
import org.openl.ie.constrainer.impl.DomainBits2;
import org.openl.ie.constrainer.impl.DomainImpl;
import org.openl.ie.constrainer.impl.IntDomainHistory;
import org.openl.ie.constrainer.impl.IntExpImpl;
import org.openl.ie.constrainer.impl.SubjectImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public class IntVarImpl
extends IntExpImpl
implements IntVar {
    private Domain _domain;
    private IntDomainHistory _history;

    public IntVarImpl(Constrainer constrainer) {
        this(constrainer, 1000000);
    }

    public IntVarImpl(Constrainer constrainer, int max) {
        this(constrainer, 0, max);
    }

    public IntVarImpl(Constrainer constrainer, int min, int max) {
        this(constrainer, min, max, "var");
    }

    public IntVarImpl(Constrainer constrainer, int min, int max, String name) {
        super(constrainer, name);
        this._domain = new DomainBits(this, min, max);
        this._history = new IntDomainHistory(this);
    }

    public IntVarImpl(Constrainer constrainer, int min, int max, String name, int domain_type) {
        super(constrainer, name);
        int size = max - min + 1;
        switch (domain_type) {
            case 0: {
                this._domain = new DomainImpl(this, min, max);
                break;
            }
            case 1: {
                this._domain = new DomainBits(this, min, max);
                break;
            }
            case 2: {
                this._domain = new DomainBits2(this, min, max);
                break;
            }
            case -1: {
                this._domain = size < 16 ? new DomainBits(this, min, max) : (size < 128 ? new DomainBits2(this, min, max) : new DomainImpl(this, min, max));
            }
        }
        this._history = new IntDomainHistory(this);
    }

    public IntVarImpl(Constrainer constrainer, String name) {
        this(constrainer, 0, 1000000, name);
    }

    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        if (this.bound()) {
            return (double)this.max() * factor;
        }
        Double coef = (Double)map.get(this);
        if (coef == null) {
            map.put(this, new Double(factor));
        } else {
            map.put(this, new Double(factor + coef));
        }
        return 0.0;
    }

    public boolean contains(int value) {
        return this._domain.contains(value);
    }

    public Undo createUndo() {
        this._history.saveUndo();
        return UndoIntVarImpl.getIntVarUndo();
    }

    public String domainToString() {
        return this._domain.toString();
    }

    public int domainType() {
        return this._domain.type();
    }

    public void forceInsert(int val) {
        this._domain.forceInsert(val);
    }

    public void forceMax(int val) {
        this._domain.forceMax(val);
    }

    public void forceMin(int val) {
        this._domain.forceMin(val);
    }

    public void forceSize(int val) {
        this._domain.forceSize(val);
    }

    public IntDomainHistory history() {
        return this._history;
    }

    public Goal instantiate() {
        return new GoalInstantiate(this);
    }

    public boolean isLinear() {
        return true;
    }

    public void iterateDomain(IntExp.IntDomainIterator it) throws Failure {
        this._domain.iterateDomain(it);
    }

    public int max() {
        return this._domain.max();
    }

    public int min() {
        return this._domain.min();
    }

    public void propagate() throws Failure {
        this._history.propagate();
    }

    protected void removeRangeInternal(int min, int max) throws Failure {
        if (this._domain.removeRange(min, max)) {
            this._history.setMin(this._domain.min());
            this._history.setMax(this._domain.max());
            this._history.remove(min, max);
            this.addToPropagationQueue();
        }
    }

    public void removeValue(int value) throws Failure {
        if (this._domain.removeValue(value)) {
            this._history.setMin(this._domain.min());
            this._history.setMax(this._domain.max());
            this._history.remove(value);
            this.addToPropagationQueue();
        }
    }

    public void setMax(int max) throws Failure {
        if (this._domain.setMax(max)) {
            this._history.setMax(this.max());
            this.addToPropagationQueue();
        }
    }

    public void setMin(int min) throws Failure {
        if (this._domain.setMin(min)) {
            this._history.setMin(this.min());
            this.addToPropagationQueue();
        }
    }

    public void setValue(int value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    public int size() {
        return this._domain.size();
    }

    public int value() throws Failure {
        if (!this.bound()) {
            this.constrainer().fail("Attempt to get value of the unbound variable " + this);
        }
        return this._domain.min();
    }

    static final class UndoIntVarImpl
    extends SubjectImpl.UndoSubject {
        static ReusableFactory _factory = new ReusableFactory(){

            protected Reusable createNewElement() {
                return new UndoIntVarImpl();
            }
        };
        int _history_index;

        UndoIntVarImpl() {
        }

        static UndoIntVarImpl getIntVarUndo() {
            return (UndoIntVarImpl)_factory.getElement();
        }

        public String toString() {
            return "UndoIntVar " + this.undoable();
        }

        public void undo() {
            IntVarImpl intvar = (IntVarImpl)this.undoable();
            intvar.history().restore(this._history_index);
            super.undo();
        }

        public void undoable(Undoable u) {
            super.undoable(u);
            IntVarImpl intvar = (IntVarImpl)u;
            this._history_index = intvar.history().currentIndex();
        }
    }
}

