/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.impl.UndoableImpl;

public final class UndoableBits
extends UndoableImpl {
    private boolean[] _bits;
    private int _min;

    public UndoableBits(Constrainer c, int min, int max) {
        super(c);
        int size = max - min + 1;
        this._bits = new boolean[size];
        for (int j = 0; j < size; ++j) {
            this._bits[j] = false;
        }
        this._min = min;
    }

    public UndoableBits(UndoableBits oldbits) {
        super(oldbits.constrainer());
        boolean[] bits = oldbits.bits();
        this._bits = new boolean[bits.length];
        for (int j = 0; j < bits.length; ++j) {
            this._bits[j] = bits[j];
        }
        this._min = oldbits.min();
        this.object(oldbits.object());
    }

    public boolean bit(int value) {
        return this._bits[value - this._min];
    }

    public void bit(int value, boolean b) {
        this._bits[value - this._min] = b;
    }

    boolean[] bits() {
        return this._bits;
    }

    public Undo createUndo() {
        return null;
    }

    public int max() {
        return this._min + this._bits.length - 1;
    }

    public int min() {
        return this._min;
    }

    int size(boolean flag) {
        int s = 0;
        for (int j = 0; j < this._bits.length; ++j) {
            if (this._bits[j] != flag) continue;
            ++s;
        }
        return s;
    }

    public String toString() {
        String s = "bits(" + this._min + ";" + this.max() + "):";
        for (int i = 0; i < this._bits.length; ++i) {
            s = s + " " + (this._min + i) + (this._bits[i] ? "=1" : "=0");
        }
        return s;
    }
}

