/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.lpsolver;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.lpsolver.ConstrainerLP;
import org.openl.ie.constrainer.lpsolver.LPConstraint;
import org.openl.ie.exigensimplex.LPProblem;
import org.openl.ie.exigensimplex.MatrixRow;
import org.openl.ie.exigensimplex.NoSolutionException;
import org.openl.ie.exigensimplex.VarBounds;
import org.openl.ie.exigensimplex.glpkimpl.GLPKLPProblem;

public class GoalSimplexSolve
extends GoalImpl {
    private ConstrainerLP _smpl = null;
    private LPProblem lpx = null;

    public GoalSimplexSolve(Constrainer c, ConstrainerLP smpl) {
        super(c, "");
        this._smpl = smpl;
    }

    public Goal execute() throws Failure {
        int i;
        this.lpx = new GLPKLPProblem();
        this.lpx.setIntParam(1, 0);
        int nbVars = this._smpl.nbVars();
        int nbConstr = this._smpl.nbConstraints();
        if (nbVars == 0) {
            throw new Failure("there is no need to solve empty problem");
        }
        this.lpx.addColumns(nbVars);
        if (nbConstr > 0) {
            this.lpx.addRows(nbConstr);
        } else {
            this.lpx.addRows(1);
        }
        for (i = 0; i < nbConstr; ++i) {
            LPConstraint lpc = this._smpl.getLPConstraint(i);
            this.lpx.setRowName(i, "Row" + i);
            this.lpx.setRowBounds(i, lpc.getType(), lpc.getLb(), lpc.getUb());
            this.lpx.setMatrixRow(i, new MatrixRow(lpc.getLocations(), lpc.getValues()));
        }
        for (i = 0; i < nbVars; ++i) {
            FloatVar var = this._smpl.getVar(i);
            VarBounds vt = new VarBounds(2, var.min(), var.max());
            this.lpx.setColumnName(i, "var" + i);
            this.lpx.setColumnCoeff(i, this._smpl.getCostCoeff(i));
            this.lpx.setColumnBounds(i, vt.getType(), vt.getLb(), vt.getUb());
        }
        this.lpx.setObjConst(this._smpl.getFreeTerm());
        int status = this.lpx.solveLP(this._smpl.toBeMaximized() ? 1 : 2);
        if (status != 0) {
            throw new Failure(this.lpx.errorAsString(status));
        }
        try {
            for (int i2 = 0; i2 < nbVars; ++i2) {
                this._smpl.getVar(i2).setValue(this.lpx.getColumnValue(i2));
            }
        }
        catch (NoSolutionException ex) {
            throw new Failure(this.lpx.errorAsString(ex.getErrorCode()));
        }
        this.lpx.deleteCurrentLP();
        return null;
    }
}

