/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.scheduler;

import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.scheduler.AlternativeResourceConstraint;
import org.openl.ie.scheduler.Job;
import org.openl.ie.scheduler.Resource;
import org.openl.util.Log;

public class GoalAssign
extends GoalImpl {
    private Resource _resource;
    private Job _job;
    private int _capacity;
    private IntVar _capacityVar;
    private AlternativeResourceConstraint _requirement;

    public GoalAssign(AlternativeResourceConstraint req, int resourceNum) {
        super(req.constrainer(), "");
        this._requirement = req;
        this._job = this._requirement.getJob();
        this._resource = this._requirement.getResource(resourceNum);
        this._capacity = this._requirement.getCapacity();
        this._capacityVar = this._requirement.getCapacityVar();
        this.name("GoalAssign(" + this._job + "," + this._resource + ")");
    }

    private boolean apply() throws Failure {
        IntExp capvar;
        int t;
        int c_end;
        int c_start = this._resource.timeMin() < this._job.startMin() ? this._job.startMin() : this._resource.timeMin();
        int n = c_end = this._resource.timeMax() > this._job.endMax() ? this._job.endMax() : this._resource.timeMax();
        if (c_start > c_end) {
            String msg = "Resource " + this._resource.getName() + " and Job " + this._job.getName() + " do not overlap";
            Log.error((Object)(this + " Failure: " + msg));
            this.constrainer().fail(msg);
        }
        if (!this._job.bound()) {
            this.constrainer().fail("Cannot assign unbound job " + this._job);
        }
        if (this._capacityVar != null) {
            if (!this._capacityVar.bound()) {
                this.constrainer().fail("Cannot assign unbound job " + this._job + " : capacity var is not bound");
            } else {
                this._capacity = this._capacityVar.value();
            }
        }
        for (t = c_start; t < c_end; ++t) {
            capvar = this._resource.getCapacityVar(t);
            if (capvar.max() >= this._capacity) continue;
            this.constrainer().fail("resource assigning");
        }
        for (t = c_start; t < c_end; ++t) {
            capvar = this._resource.getCapacityVar(t);
            capvar.setMax(capvar.max() - this._capacity);
        }
        return true;
    }

    public Goal execute() throws Failure {
        try {
            this.apply();
        }
        catch (Failure f) {
            this.constrainer().fail("Unable to bind job " + this._job + " to resource " + this._resource);
            this._job.saveAssignmentInfo();
        }
        if (this._requirement != null) {
            this._job.saveAssignmentInfo();
        }
        this._requirement.assignResource(this._resource);
        return null;
    }
}

