/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.scheduler;

import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.scheduler.Resource;
import org.openl.ie.scheduler.Schedule;

public class ResourceDiscrete
implements Resource {
    private Object _object;
    private Schedule _schedule;
    private Constrainer _constrainer;
    private String _name;
    private IntExpArray _caps;
    private int _timeMin;
    private int _timeMax;
    private int _duration;

    public ResourceDiscrete(Schedule sch, int capacity) {
        this.init(sch, sch.start(), sch.end(), capacity);
    }

    public ResourceDiscrete(Schedule sch, int timeMin, int timeMax, int capacity) {
        this.init(sch, timeMin, timeMax, capacity);
    }

    public IntExpArray caps() {
        return this._caps;
    }

    public Constrainer constrainer() {
        return this._constrainer;
    }

    public int duration() {
        return this._duration;
    }

    public String getAssignment() {
        return this._schedule.getAssignments(this);
    }

    public int getCapacityMax(int time) throws Failure {
        return this._caps.get(time - this._timeMin).max();
    }

    public int getCapacityMin(int time) throws Failure {
        return this._caps.get(time - this._timeMin).min();
    }

    public IntExp getCapacityVar(int time) throws Failure {
        return this._caps.get(time - this._timeMin);
    }

    public String getName() {
        return this._name;
    }

    public Object getObject() {
        return this._object;
    }

    private void init(Schedule sch, int timeMin, int timeMax, int capacity) {
        this._object = null;
        this._schedule = sch;
        this._constrainer = this._schedule.constrainer();
        this._timeMax = timeMax;
        this._timeMin = timeMin;
        this._duration = this._timeMax - this._timeMin;
        this._caps = new IntExpArray(this._constrainer, this._duration);
        for (int i = 0; i < this._duration; ++i) {
            this._caps.set(this._constrainer.addIntVar(0, capacity), i);
        }
    }

    public String mapString() {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (int i = 0; i < this._duration; ++i) {
            s.append("." + this._caps.get(i).max());
        }
        s.append(".]");
        return s.toString();
    }

    public void setCapacityMax(int time, int capacity) throws Failure {
        this._caps.get(time - this._timeMin).setMax(capacity);
    }

    public void setCapacityMax(int time1, int time2, int capacity) throws Failure {
        for (int i = time1 - this._timeMin; i < time2 - this._timeMin; ++i) {
            this._caps.get(i).setMax(capacity);
        }
    }

    public void setCapacityMin(int time, int capacity) throws Failure {
        this._caps.get(time - this._timeMin).setMin(capacity);
    }

    public void setCapacityMin(int time1, int time2, int capacity) throws Failure {
        for (int i = time1 - this._timeMin; i < time2 - this._timeMin; ++i) {
            this._caps.get(i).setMin(capacity);
        }
    }

    public void setName(String name) {
        this._name = name;
        for (int i = 0; i < this._duration; ++i) {
            Integer v = new Integer(i);
            this._caps.get(i).name(this._name + "." + v);
        }
    }

    public void setObject(Object o) {
        this._object = o;
    }

    public int timeMax() {
        return this._timeMax;
    }

    public int timeMin() {
        return this._timeMin;
    }

    public String toString() {
        String assignments = this._schedule.getAssignments(this);
        return this.getName() + (assignments.equalsIgnoreCase("") ? "" : " : " + assignments);
    }
}

