/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.simplex;

import org.openl.ie.simplex.Status;

public class LPErrorCodes {
    public static final int NO_LP = 3001;
    public static final int LPX_OPT = LPErrorCodes.native_LPX_OPT();
    public static final int LPX_FEAS = LPErrorCodes.native_LPX_FEAS();
    public static final int LPX_INFEAS = LPErrorCodes.native_LPX_INFEAS();
    public static final int LPX_NOFEAS = LPErrorCodes.native_LPX_NOFEAS();
    public static final int LPX_UNBND = LPErrorCodes.native_LPX_UNBND();
    public static final int LPX_UNDEF = LPErrorCodes.native_LPX_UNDEF();

    public static boolean isFeasible(int errorCode) {
        return errorCode == LPX_OPT || errorCode == LPX_FEAS;
    }

    public static boolean isOptimal(int errorCode) {
        return errorCode == LPX_OPT;
    }

    private static native int native_LPX_FEAS();

    private static native int native_LPX_INFEAS();

    private static native int native_LPX_NOFEAS();

    private static native int native_LPX_OPT();

    private static native int native_LPX_UNBND();

    private static native int native_LPX_UNDEF();

    private LPErrorCodes() {
    }

    static {
        Status.dictionary.put(new Integer(3001), "LP problem hasn't been created yet");
        Status.dictionary.put(new Integer(LPX_OPT), "OPTIMAL");
        Status.dictionary.put(new Integer(LPX_FEAS), "FEASIBLE");
        Status.dictionary.put(new Integer(LPX_INFEAS), "INFEASIBLE (INTERMEDIATE)");
        Status.dictionary.put(new Integer(LPX_NOFEAS), "INFEASIBLE (FINAL)");
        Status.dictionary.put(new Integer(LPX_UNBND), "UNBOUNDED");
        Status.dictionary.put(new Integer(LPX_UNDEF), "UNDEFINED");
    }
}

