/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.simplex;

import org.openl.ie.simplex.Status;

public class VarInfo {
    public static final int LPX_BS = VarInfo.native_LPX_BS();
    public static final int LPX_NL = VarInfo.native_LPX_NL();
    public static final int LPX_NU = VarInfo.native_LPX_NU();
    public static final int LPX_NF = VarInfo.native_LPX_NF();
    public static final int LPX_NS = VarInfo.native_LPX_NS();
    int _status;
    double _prim;
    double _dual;

    private static native int native_LPX_BS();

    private static native int native_LPX_NF();

    private static native int native_LPX_NL();

    private static native int native_LPX_NS();

    private static native int native_LPX_NU();

    VarInfo(double[] parms) {
        this.setStatus((int)parms[0]);
        this._prim = parms[1];
        this._dual = parms[2];
    }

    public VarInfo(int status, double prim, double dual) {
        this.setStatus(status);
        this._prim = prim;
        this._dual = dual;
    }

    public double getDual() {
        return this._dual;
    }

    public double getPrim() {
        return this._prim;
    }

    public int getStatus() {
        return this._status;
    }

    private boolean isLegalStatus(int status) {
        return status == LPX_BS || status == LPX_NL || status == LPX_NU || status == LPX_NF || status == LPX_NS;
    }

    private void setStatus(int status) {
        this._status = this.isLegalStatus(status) ? status : LPX_NF;
    }

    public String toString() {
        String varinfo = "[Type=" + Status.translate(this._status);
        varinfo = this._prim != 0.0 ? varinfo + " prim=" + this._prim : varinfo + " dual=" + this._dual;
        varinfo = varinfo + "]";
        return varinfo;
    }

    static {
        Status.dictionary.put(new Integer(LPX_BS), "basic");
        Status.dictionary.put(new Integer(LPX_NL), "non-basic_lb");
        Status.dictionary.put(new Integer(LPX_NU), "non-basic_ub");
        Status.dictionary.put(new Integer(LPX_NF), "non-basic_free");
        Status.dictionary.put(new Integer(LPX_NS), "non-basic_fixed");
    }
}

