/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.differs;

import java.util.HashMap;
import java.util.Map;
import org.openl.rules.diff.differs.MergeResult;
import org.openl.rules.diff.differs.ProjectionDiffer;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.hierarchy.ProjectionProperty;

public class ProjectionDifferImpl
implements ProjectionDiffer {
    @Override
    public boolean compare(Projection original, Projection other) {
        Map<String, ProjectionProperty> map1 = ProjectionDifferImpl.buildMap(original);
        Map<String, ProjectionProperty> map2 = ProjectionDifferImpl.buildMap(other);
        MergeResult merged = MergeResult.mergeNames(map1.keySet(), map2.keySet());
        if (merged.getAdded().length > 0 || merged.getRemoved().length > 0) {
            return false;
        }
        for (String propertyName : merged.getCommon()) {
            ProjectionProperty p2;
            ProjectionProperty p1 = map1.get(propertyName);
            if (this.isEquals(p1, p2 = map2.get(propertyName))) continue;
            return false;
        }
        return true;
    }

    protected boolean isEquals(ProjectionProperty p1, ProjectionProperty p2) {
        Object v1 = p1.getRawValue();
        Object v2 = p2.getRawValue();
        if (v1 == null) {
            return v1 == v2;
        }
        return v1.equals(v2);
    }

    protected static Map<String, ProjectionProperty> buildMap(Projection projection) {
        HashMap<String, ProjectionProperty> map = new HashMap<String, ProjectionProperty>();
        for (ProjectionProperty property : projection.getProperties()) {
            map.put(property.getName(), property);
        }
        return map;
    }
}

