/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.hierarchy.ProjectionProperty;
import org.openl.rules.diff.hierarchy.PropertySet;

public class AbstractProjection
implements Projection {
    private String name;
    private String type;
    private PropertySet properties;
    private List<Projection> children;

    public AbstractProjection(String name, String type) {
        this.name = name;
        this.type = type;
        this.properties = new PropertySet();
        this.children = new ArrayList<Projection>();
    }

    @Override
    public List<Projection> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<ProjectionProperty> getProperties() {
        return this.properties.getAll();
    }

    @Override
    public ProjectionProperty getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        ProjectionProperty p = this.properties.get(propertyName);
        return p == null ? p : p.getRawValue();
    }

    public void addChild(Projection child) {
        this.children.add(child);
    }

    public void addProperty(ProjectionProperty property) {
        this.properties.add(property);
    }
}

