/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.xls;

import java.util.TreeMap;
import org.openl.rules.diff.hierarchy.AbstractProperty;
import org.openl.rules.diff.xls.XlsProjection;
import org.openl.rules.diff.xls.XlsProjectionType;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeAdapter;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IOpenLTable;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.source.IOpenSourceCodeModule;

public final class XlsProjectionBuilder {
    public static XlsProjection build(XlsMetaInfo xmi, String xlsName) {
        XlsProjection projection = new XlsProjection(xlsName, XlsProjectionType.BOOK);
        XlsModuleSyntaxNode xsn = xmi.getXlsModuleNode();
        TreeMap<String, XlsProjection> sheetProjections = new TreeMap<String, XlsProjection>();
        TableSyntaxNode[] nodes = xsn.getXlsTableSyntaxNodes();
        for (TableSyntaxNode node : nodes) {
            TableSyntaxNodeAdapter table;
            String header;
            IOpenSourceCodeModule sheet = node.getModule();
            String sheetName = ((XlsSheetSourceCodeModule)sheet).getSheetName();
            XlsProjection sheetProjection = (XlsProjection)sheetProjections.get(sheetName);
            if (sheetProjection == null) {
                sheetProjection = new XlsProjection(sheetName, XlsProjectionType.SHEET);
                sheetProjections.put(sheetName, sheetProjection);
            }
            String tableName = (header = (table = new TableSyntaxNodeAdapter(node)).getGridTable().getCell(0, 0).getStringValue()) == null ? "" : header;
            GridLocation location = node.getGridLocation();
            tableName = tableName + " (" + location.getStart() + ":" + location.getEnd() + ")";
            sheetProjection.addChild(XlsProjectionBuilder.buildTable((IOpenLTable)table, tableName));
        }
        for (XlsProjection sheetProjection : sheetProjections.values()) {
            projection.addChild(sheetProjection);
        }
        return projection;
    }

    public static XlsProjection buildTable(IOpenLTable table, String tableName) {
        XlsProjection projection = new XlsProjection(tableName, XlsProjectionType.TABLE);
        projection.setData(table);
        XlsProjection grid = new XlsProjection("GRID", XlsProjectionType.GRID);
        projection.addChild(grid);
        IGridTable gridTable = table.getGridTable();
        int height = gridTable.getHeight();
        int width = gridTable.getWidth();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                ICell cell = gridTable.getCell(j, i);
                grid.addChild(XlsProjectionBuilder.buildCell(cell, i + "x" + j));
            }
        }
        return projection;
    }

    public static XlsProjection buildRow(ILogicalTable row, String rowName) {
        XlsProjection projection = new XlsProjection(rowName, XlsProjectionType.ROW);
        IGridTable grid = row.getSource();
        int height = grid.getHeight();
        int width = grid.getWidth();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                ICell cell = grid.getCell(j, i);
                projection.addChild(XlsProjectionBuilder.buildCell(cell, i + "x" + j));
            }
        }
        return projection;
    }

    public static XlsProjection buildCell(ICell cell, String cellName) {
        Object cellValue = cell.getObjectValue();
        XlsProjection projection = new XlsProjection(cellName, XlsProjectionType.CELL);
        projection.addProperty(new AbstractProperty(XlsProjectionType.CELL_VALUE.name(), cellValue));
        projection.setData(cell);
        return projection;
    }

    public static XlsProjection buildCellStyle(ICellStyle style) {
        return new XlsProjection("style", XlsProjectionType.CELL_STYLE);
    }

    public static XlsProjection buildCellFont(ICellFont font) {
        return new XlsProjection("font", XlsProjectionType.CELL_FONT);
    }
}

