/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.xls2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openl.OpenClassUtil;
import org.openl.binding.IBoundCode;
import org.openl.classloader.OpenLBundleClassLoader;
import org.openl.conf.IUserContext;
import org.openl.conf.UserContext;
import org.openl.rules.diff.tree.DiffTreeNode;
import org.openl.rules.diff.xls.XlsProjectionDiffer;
import org.openl.rules.diff.xls2.DiffPair;
import org.openl.rules.diff.xls2.DiffTreeBuilder2;
import org.openl.rules.diff.xls2.IterClosure;
import org.openl.rules.diff.xls2.XlsTable;
import org.openl.rules.lang.xls.XlsBinder;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.syntax.code.IParsedCode;
import org.openl.types.IOpenClass;
import org.openl.xls.sequential.SequentialParser;

public class XlsDiff2 {
    private List<XlsTable> tables1;
    private List<XlsTable> tables2;
    private static final String GUESS_SAME = "1-same";
    private static final String GUESS_SAME_PLACE = "2-samePlace";
    private static final String GUESS_CAN_BE_SAME = "3-canBeSame";
    private static final String GUESS_MAY_BE_SAME = "4-mayBeSame";
    private Map<String, List<DiffPair>> diffGuess = new TreeMap<String, List<DiffPair>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<XlsTable> load(IOpenSourceCodeModule src) {
        ArrayList<XlsTable> arrayList;
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        OpenLBundleClassLoader bundleCl = null;
        try {
            bundleCl = new OpenLBundleClassLoader(oldCl);
            Thread.currentThread().setContextClassLoader((ClassLoader)bundleCl);
            UserContext ucxt = new UserContext((ClassLoader)bundleCl, ".");
            IParsedCode pc = new SequentialParser((IUserContext)ucxt).parseAsModule(src);
            IBoundCode bc = new XlsBinder((IUserContext)ucxt).bind(pc);
            IOpenClass ioc = bc.getTopNode().getType();
            XlsMetaInfo xmi = (XlsMetaInfo)ioc.getMetaInfo();
            XlsModuleSyntaxNode xsn = xmi.getXlsModuleNode();
            TableSyntaxNode[] nodes = xsn.getXlsTableSyntaxNodes();
            ArrayList<XlsTable> tables = new ArrayList<XlsTable>(nodes.length);
            for (TableSyntaxNode node : nodes) {
                tables.add(new XlsTable(node));
            }
            arrayList = tables;
        }
        catch (Throwable throwable) {
            OpenClassUtil.releaseClassLoader(bundleCl);
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
        OpenClassUtil.releaseClassLoader((ClassLoader)bundleCl);
        Thread.currentThread().setContextClassLoader(oldCl);
        return arrayList;
    }

    public DiffTreeNode diffFiles(File xlsFile1, File xlsFile2) {
        this.load(xlsFile1, xlsFile2);
        this.diff();
        return this.buildTree();
    }

    private void load(File xlsFile1, File xlsFile2) {
        this.tables1 = xlsFile1 == null ? Collections.emptyList() : this.load((IOpenSourceCodeModule)new URLSourceCodeModule(URLSourceCodeModule.toUrl((File)xlsFile1)));
        this.tables2 = xlsFile2 == null ? Collections.emptyList() : this.load((IOpenSourceCodeModule)new URLSourceCodeModule(URLSourceCodeModule.toUrl((File)xlsFile2)));
    }

    private void add(String guess, DiffPair r) {
        List list = this.diffGuess.computeIfAbsent(guess, e -> new LinkedList());
        list.add(r);
    }

    private void diff() {
        this.iterate(new IterClosure(){

            @Override
            public boolean remove(XlsTable t1, XlsTable t2) {
                String s2;
                String s1;
                if (t1.getSheetName().equals(t2.getSheetName()) && (s1 = t1.getLocation().getStart().toString()).equals(s2 = t2.getLocation().getStart().toString())) {
                    String e2;
                    boolean sameName = t1.getTableName().equals(t2.getTableName());
                    String e1 = t1.getLocation().getEnd().toString();
                    if (e1.equals(e2 = t2.getLocation().getEnd().toString())) {
                        if (sameName) {
                            XlsDiff2.this.add(XlsDiff2.GUESS_SAME, new DiffPair(t1, t2));
                        } else {
                            XlsDiff2.this.add(XlsDiff2.GUESS_SAME_PLACE, new DiffPair(t1, t2));
                        }
                        return true;
                    }
                    if (sameName) {
                        XlsDiff2.this.add(XlsDiff2.GUESS_CAN_BE_SAME, new DiffPair(t1, t2));
                        return true;
                    }
                }
                return false;
            }
        });
        this.iterate(new IterClosure(){

            @Override
            public boolean remove(XlsTable t1, XlsTable t2) {
                boolean sameName;
                if (t1.getSheetName().equals(t2.getSheetName()) && (sameName = t1.getTableName().equals(t2.getTableName()))) {
                    XlsDiff2.this.add(XlsDiff2.GUESS_MAY_BE_SAME, new DiffPair(t1, t2));
                    return true;
                }
                return false;
            }
        });
    }

    private void iterate(IterClosure closure) {
        Iterator<XlsTable> i1 = this.tables1.iterator();
        block0: while (i1.hasNext()) {
            XlsTable t1 = i1.next();
            Iterator<XlsTable> i2 = this.tables2.iterator();
            while (i2.hasNext()) {
                XlsTable t2 = i2.next();
                if (!closure.remove(t1, t2)) continue;
                i1.remove();
                i2.remove();
                continue block0;
            }
        }
    }

    private DiffTreeNode buildTree() {
        DiffTreeBuilder2 builder = new DiffTreeBuilder2();
        builder.setProjectionDiffer(new XlsProjectionDiffer());
        for (String guess : this.diffGuess.keySet()) {
            for (DiffPair pair : this.diffGuess.get(guess)) {
                this.checkGrid(pair);
                builder.add(pair);
            }
        }
        for (XlsTable t : this.tables1) {
            builder.add(new DiffPair(t, null));
        }
        for (XlsTable t : this.tables2) {
            builder.add(new DiffPair(null, t));
        }
        return builder.compare();
    }

    private void checkGrid(DiffPair pair) {
        IGridTable grid1 = pair.getTable1().getTable().getGridTable();
        IGridTable grid2 = pair.getTable2().getTable().getGridTable();
        ArrayList<ICell> diff1 = new ArrayList<ICell>();
        ArrayList<ICell> diff2 = new ArrayList<ICell>();
        if (grid1.getWidth() == grid2.getWidth() && grid1.getHeight() == grid2.getHeight()) {
            this.compareRows(grid1, grid2, diff1);
            this.compareRows(grid2, grid1, diff2);
        } else if (grid1.getWidth() == grid2.getWidth()) {
            this.compareRows(grid1, grid2, diff1);
            this.compareRows(grid2, grid1, diff2);
        } else if (grid1.getHeight() == grid2.getHeight()) {
            this.compareCols(grid1, grid2, diff1);
            this.compareCols(grid2, grid1, diff2);
        }
        if (!diff1.isEmpty()) {
            pair.setDiffCells1(diff1);
        }
        if (!diff2.isEmpty()) {
            pair.setDiffCells2(diff2);
        }
    }

    private void compareRows(IGridTable grid1, IGridTable grid2, List<ICell> diff) {
        int y1;
        int nPart;
        boolean[] matched = new boolean[grid1.getHeight()];
        int[] match2 = new int[grid1.getHeight()];
        int y2s = 0;
        block0: for (int y12 = 0; y12 < grid1.getHeight(); ++y12) {
            for (int y2 = y2s; y2 < grid2.getHeight(); ++y2) {
                int nDiff = this.getDiffsCount(grid1, grid2, y12, y2);
                if (nDiff != 0) continue;
                matched[y12] = true;
                match2[y12] = y2;
                y2s = y2 + 1;
                continue block0;
            }
        }
        do {
            nPart = 0;
            y2s = 0;
            for (y1 = 0; y1 < grid1.getHeight(); ++y1) {
                int y1e;
                if (matched[y1]) {
                    y2s = match2[y1] + 1;
                    continue;
                }
                int y2e = grid2.getHeight();
                for (y1e = y1; y1e < grid1.getHeight(); ++y1e) {
                    if (!matched[y1e]) continue;
                    y2e = match2[y1e];
                    break;
                }
                if (y2s >= grid2.getHeight()) continue;
                int i1 = y1;
                int i2 = y2s;
                int n = this.getDiffsCount(grid1, grid2, i1, i2);
                for (int y = y1; y < y1e; ++y) {
                    for (int y2 = y2s; y2 < y2e; ++y2) {
                        int m = this.getDiffsCount(grid1, grid2, y, y2);
                        if (m >= n) continue;
                        n = m;
                        i1 = y;
                        i2 = y2;
                    }
                }
                matched[i1] = true;
                match2[i1] = i2;
                for (int x = 0; x < grid1.getWidth(); ++x) {
                    ICell c2;
                    ICell c1 = grid1.getCell(x, i1);
                    if (!this.notEquals(c1, c2 = grid2.getCell(x, i2))) continue;
                    diff.add(c1);
                }
                ++nPart;
                y1 = i1 - 1;
            }
        } while (nPart > 0);
        for (y1 = 0; y1 < grid1.getHeight(); ++y1) {
            if (matched[y1]) continue;
            for (int x = 0; x < grid1.getWidth(); ++x) {
                ICell c1 = grid1.getCell(x, y1);
                diff.add(c1);
            }
        }
    }

    private int getDiffsCount(IGridTable grid1, IGridTable grid2, int y1, int y2) {
        int nDiff = 0;
        for (int x = 0; x < grid1.getWidth(); ++x) {
            ICell c2;
            ICell c1 = grid1.getCell(x, y1);
            if (!this.notEquals(c1, c2 = grid2.getCell(x, y2))) continue;
            ++nDiff;
        }
        return nDiff;
    }

    private void compareCols(IGridTable grid1, IGridTable grid2, List<ICell> diff) {
        ArrayList<ICell> iDiff = new ArrayList<ICell>();
        this.compareRows((IGridTable)grid1.transpose(), (IGridTable)grid2.transpose(), iDiff);
        for (ICell c : iDiff) {
            diff.add(grid1.getCell(c.getRow(), c.getColumn()));
        }
    }

    private boolean notEquals(ICell c1, ICell c2) {
        Object o1 = c1.getObjectValue();
        Object o2 = c2.getObjectValue();
        if (o1 == null) {
            return o2 != null;
        }
        return !o1.equals(o2);
    }
}

