/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.xls2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openl.ICompileContext;
import org.openl.OpenClassUtil;
import org.openl.binding.IBoundCode;
import org.openl.classloader.OpenLClassLoader;
import org.openl.conf.IUserContext;
import org.openl.conf.UserContext;
import org.openl.impl.DefaultCompileContext;
import org.openl.rules.diff.tree.DiffTreeNode;
import org.openl.rules.diff.xls.XlsProjectionDiffer;
import org.openl.rules.diff.xls2.DiffPair;
import org.openl.rules.diff.xls2.DiffTreeBuilder2;
import org.openl.rules.diff.xls2.IterClosure;
import org.openl.rules.diff.xls2.XlsTable;
import org.openl.rules.lang.xls.XlsBinder;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.syntax.code.IParsedCode;
import org.openl.types.IOpenClass;
import org.openl.xls.Parser;

public class XlsDiff2 {
    private List<XlsTable> tables1;
    private List<XlsTable> tables2;
    private static final String GUESS_SAME = "1-same";
    private static final String GUESS_SAME_PLACE = "2-samePlace";
    private static final String GUESS_CAN_BE_SAME = "3-canBeSame";
    private static final String GUESS_MAY_BE_SAME = "4-mayBeSame";
    private final Map<String, List<DiffPair>> diffGuess = new TreeMap<String, List<DiffPair>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<XlsTable> load(IOpenSourceCodeModule src) {
        ArrayList<XlsTable> arrayList;
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        OpenLClassLoader classLoader = null;
        try {
            classLoader = new OpenLClassLoader(oldCl);
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
            UserContext ucxt = new UserContext((ClassLoader)classLoader, ".");
            IParsedCode pc = new Parser((IUserContext)ucxt).parseAsModule(src);
            IBoundCode bc = new XlsBinder((ICompileContext)new DefaultCompileContext(), (IUserContext)ucxt).bind(pc);
            IOpenClass ioc = bc.getTopNode().getType();
            XlsMetaInfo xmi = (XlsMetaInfo)ioc.getMetaInfo();
            XlsModuleSyntaxNode xsn = xmi.getXlsModuleNode();
            TableSyntaxNode[] nodes = xsn.getXlsTableSyntaxNodes();
            ArrayList<XlsTable> tables = new ArrayList<XlsTable>(nodes.length);
            for (TableSyntaxNode node : nodes) {
                tables.add(new XlsTable(node));
            }
            arrayList = tables;
        }
        catch (Throwable throwable) {
            OpenClassUtil.releaseClassLoader(classLoader);
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
        OpenClassUtil.releaseClassLoader((ClassLoader)classLoader);
        Thread.currentThread().setContextClassLoader(oldCl);
        return arrayList;
    }

    public DiffTreeNode diffFiles(File xlsFile1, File xlsFile2) {
        this.load(xlsFile1, xlsFile2);
        this.diff();
        return this.buildTree();
    }

    private void load(File xlsFile1, File xlsFile2) {
        this.tables1 = xlsFile1 == null ? Collections.emptyList() : this.load((IOpenSourceCodeModule)new URLSourceCodeModule(URLSourceCodeModule.toUrl((File)xlsFile1)));
        this.tables2 = xlsFile2 == null ? Collections.emptyList() : this.load((IOpenSourceCodeModule)new URLSourceCodeModule(URLSourceCodeModule.toUrl((File)xlsFile2)));
    }

    private void add(String guess, DiffPair r) {
        List list = this.diffGuess.computeIfAbsent(guess, e -> new LinkedList());
        list.add(r);
    }

    private void diff() {
        this.iterate(new IterClosure(){

            @Override
            public boolean remove(XlsTable t1, XlsTable t2) {
                String s2;
                String s1;
                if (t1.getSheetName().equals(t2.getSheetName()) && (s1 = t1.getLocation().getStart().toString()).equals(s2 = t2.getLocation().getStart().toString())) {
                    String e2;
                    boolean sameName = t1.getTableName().equals(t2.getTableName());
                    String e1 = t1.getLocation().getEnd().toString();
                    if (e1.equals(e2 = t2.getLocation().getEnd().toString())) {
                        if (sameName) {
                            XlsDiff2.this.add(XlsDiff2.GUESS_SAME, new DiffPair(t1, t2));
                        } else {
                            XlsDiff2.this.add(XlsDiff2.GUESS_SAME_PLACE, new DiffPair(t1, t2));
                        }
                        return true;
                    }
                    if (sameName) {
                        XlsDiff2.this.add(XlsDiff2.GUESS_CAN_BE_SAME, new DiffPair(t1, t2));
                        return true;
                    }
                }
                return false;
            }
        });
        this.iterate(new IterClosure(){

            @Override
            public boolean remove(XlsTable t1, XlsTable t2) {
                boolean sameName;
                if (t1.getSheetName().equals(t2.getSheetName()) && (sameName = t1.getTableName().equals(t2.getTableName()))) {
                    XlsDiff2.this.add(XlsDiff2.GUESS_MAY_BE_SAME, new DiffPair(t1, t2));
                    return true;
                }
                return false;
            }
        });
    }

    private void iterate(IterClosure closure) {
        Iterator<XlsTable> i1 = this.tables1.iterator();
        block0: while (i1.hasNext()) {
            XlsTable t1 = i1.next();
            Iterator<XlsTable> i2 = this.tables2.iterator();
            while (i2.hasNext()) {
                XlsTable t2 = i2.next();
                if (!closure.remove(t1, t2)) continue;
                i1.remove();
                i2.remove();
                continue block0;
            }
        }
    }

    private DiffTreeNode buildTree() {
        DiffTreeBuilder2 builder = new DiffTreeBuilder2();
        builder.setProjectionDiffer(new XlsProjectionDiffer());
        for (String guess : this.diffGuess.keySet()) {
            for (DiffPair pair : this.diffGuess.get(guess)) {
                this.checkGrid(pair);
                builder.add(pair);
            }
        }
        for (XlsTable t : this.tables1) {
            builder.add(new DiffPair(t, null));
        }
        for (XlsTable t : this.tables2) {
            builder.add(new DiffPair(null, t));
        }
        return builder.compare();
    }

    private void checkGrid(DiffPair pair) {
        IGridTable grid1 = pair.getTable1().getTable().getGridTable();
        IGridTable grid2 = pair.getTable2().getTable().getGridTable();
        ArrayList<ICell> diff1 = new ArrayList<ICell>();
        ArrayList<ICell> diff2 = new ArrayList<ICell>();
        if (grid1.getWidth() == grid2.getWidth() || grid1.getHeight() == grid2.getHeight()) {
            if (grid1.getWidth() == grid2.getWidth()) {
                this.compareRows(grid1, grid2, diff1, diff2);
            } else {
                this.compareCols(grid1, grid2, diff1, diff2);
            }
        }
        if (!diff1.isEmpty()) {
            pair.setDiffCells1(diff1);
        }
        if (!diff2.isEmpty()) {
            pair.setDiffCells2(diff2);
        }
    }

    private void compareRows(IGridTable grid1, IGridTable grid2, List<ICell> diff1, List<ICell> diff2) {
        ArrayList<Integer> grid1MatchedRows = new ArrayList<Integer>();
        HashMap<Integer, RowDiff> grid1RowsState = new HashMap<Integer, RowDiff>();
        int grid2LastMatched = 0;
        int grid1Height = grid1.getHeight();
        int grid2Height = grid2.getHeight();
        for (int grid1Row = 0; grid1Row < grid1Height; ++grid1Row) {
            boolean followingRow = true;
            for (int grid2Row = grid2LastMatched; grid2Row < grid2Height; ++grid2Row) {
                List<ICell> diffs = this.getDiffs(grid1, grid2, grid1Row, grid2Row);
                if (diffs.size() == 0) {
                    List<ICell> nextRowDiffs;
                    if (!followingRow && grid1Row != grid2Row && grid1Row < grid1Height + 1 && (nextRowDiffs = this.getDiffs(grid1, grid2, grid1Row + 1, grid2Row)).size() == 0) break;
                    grid1MatchedRows.add(grid1Row);
                    grid1RowsState.put(grid1Row, new RowDiff().setRowIndex(grid2Row));
                    grid2LastMatched = grid2Row + 1;
                    break;
                }
                if (grid1Height == grid2Height) {
                    grid1RowsState.put(grid1Row, new RowDiff().setRowIndex(grid2Row).setDiff(diffs));
                    grid2LastMatched = grid2Row + 1;
                    break;
                }
                followingRow = false;
            }
            if (grid1RowsState.get(grid1Row) != null) continue;
            grid1RowsState.put(grid1Row, new RowDiff().setRowIndex(-1));
        }
        for (Integer grid1row : grid1RowsState.keySet()) {
            int from;
            if (((RowDiff)grid1RowsState.get(grid1row)).getRowIndex() != -1) continue;
            Optional<Integer> nextMatched = grid1MatchedRows.stream().filter(i -> i > grid1row).findFirst();
            int to = nextMatched.map(i -> ((RowDiff)grid1RowsState.get(i)).getRowIndex()).orElseGet(() -> ((IGridTable)grid2).getHeight());
            ArrayList<RowDiff> allRowDiffs = new ArrayList<RowDiff>();
            if (from < to) {
                for (from = grid1row > 1 ? ((RowDiff)grid1RowsState.get(grid1row - 1)).getRowIndex() + 1 : grid1row; from < to; ++from) {
                    allRowDiffs.add(new RowDiff().setRowIndex(from).setDiff(this.getDiffs(grid1, grid2, grid1row, from)));
                }
                Optional<RowDiff> minDiff = allRowDiffs.stream().min(Comparator.comparingInt(o -> o.getDiff().size()));
                RowDiff rowDiff = minDiff.orElse(new RowDiff());
                ((RowDiff)grid1RowsState.get(grid1row)).setRowIndex(rowDiff.getRowIndex()).setDiff(rowDiff.getDiff());
                continue;
            }
            for (int grid1Col = 0; grid1Col < grid1.getWidth(); ++grid1Col) {
                diff1.add(grid1.getCell(grid1Col, grid1row.intValue()));
            }
        }
        diff1.addAll(grid1RowsState.values().stream().map(RowDiff::getDiff).flatMap(Collection::stream).collect(Collectors.toList()));
        for (int grid2Row = 0; grid2Row < grid2Height; ++grid2Row) {
            int finalGrid2Row = grid2Row;
            Optional<Integer> matchedKey = grid1RowsState.keySet().stream().filter(key -> ((RowDiff)grid1RowsState.get(key)).getRowIndex() == finalGrid2Row).findFirst();
            if (matchedKey.isPresent()) {
                int rowIndex = matchedKey.get();
                if (((RowDiff)grid1RowsState.get(rowIndex)).getDiff().isEmpty()) continue;
                diff2.addAll(this.getDiffs(grid2, grid1, grid2Row, rowIndex));
                continue;
            }
            for (int grid2Col = 0; grid2Col < grid2.getWidth(); ++grid2Col) {
                diff2.add(grid2.getCell(grid2Col, grid2Row));
            }
        }
    }

    private List<ICell> getDiffs(IGridTable grid1, IGridTable grid2, int y1, int y2) {
        ArrayList<ICell> diff = new ArrayList<ICell>();
        for (int x = 0; x < grid1.getWidth(); ++x) {
            ICell c2;
            ICell c1 = grid1.getCell(x, y1);
            if (!this.notEquals(c1, c2 = grid2.getCell(x, y2))) continue;
            diff.add(c1);
        }
        return diff;
    }

    private void compareCols(IGridTable grid1, IGridTable grid2, List<ICell> diff1, List<ICell> diff2) {
        ArrayList<ICell> iDiff1 = new ArrayList<ICell>();
        ArrayList<ICell> iDiff2 = new ArrayList<ICell>();
        this.compareRows((IGridTable)grid1.transpose(), (IGridTable)grid2.transpose(), iDiff1, iDiff2);
        for (ICell c : iDiff1) {
            diff1.add(grid1.getCell(c.getRow(), c.getColumn()));
        }
        for (ICell c : iDiff2) {
            diff2.add(grid2.getCell(c.getRow(), c.getColumn()));
        }
    }

    private boolean notEquals(ICell c1, ICell c2) {
        Object o1 = c1.getObjectValue();
        Object o2 = c2.getObjectValue();
        if (o1 == null) {
            return o2 != null;
        }
        return !o1.equals(o2);
    }

    private static class RowDiff {
        private int rowIndex;
        private List<ICell> diff = new ArrayList<ICell>();

        private RowDiff() {
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public List<ICell> getDiff() {
            return this.diff;
        }

        public RowDiff setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
            return this;
        }

        public RowDiff setDiff(List<ICell> diff) {
            this.diff = diff;
            return this;
        }
    }
}

