/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.print;

import java.io.OutputStream;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.hierarchy.ProjectionProperty;
import org.openl.rules.diff.print.DiffTreePrinter;
import org.openl.rules.diff.tree.DiffElement;
import org.openl.rules.diff.tree.DiffProperty;
import org.openl.rules.diff.tree.DiffStatus;
import org.openl.rules.diff.tree.DiffTreeNode;

public class SimpleDiffTreePrinter
extends DiffTreePrinter {
    public SimpleDiffTreePrinter(DiffTreeNode tree, OutputStream out) {
        super(tree, out);
    }

    public void print() {
        this.printRoot(this.tree, 0);
    }

    private void printRoot(DiffTreeNode node, int i) {
        this.printNode(node, i);
        for (DiffTreeNode c : node.getChildren()) {
            this.printRoot(c, i + 1);
        }
    }

    private void printNode(DiffTreeNode node, int i) {
        this.intend(i);
        for (DiffElement e : node.getElements()) {
            DiffStatus s = e.getDiffStatus();
            this.writeStatus(s);
            this.write(" ");
            Projection p = e.getProjection();
            this.write(p == null ? "---" : p.getType() + ":" + p.getName());
            this.write("\t");
        }
        this.write("\n");
        DiffElement[] des = node.getElements();
        if (des.length > 2) {
            System.err.println("2 only in this printer");
        }
        DiffElement dif1 = des[0];
        DiffElement dif2 = des[1];
        DiffProperty[] diffProperties1 = dif1.getDiffProperties();
        DiffProperty[] diffProperties2 = dif2.getDiffProperties();
        for (int j = 0; j < diffProperties1.length; ++j) {
            ProjectionProperty prop1 = diffProperties1[j].getProjectionProperty();
            ProjectionProperty prop2 = null;
            String prop1Name = prop1.getName();
            DiffProperty diffProp2 = this.getProperty(prop1Name, diffProperties2);
            if (diffProp2 != null) {
                prop2 = diffProp2.getProjectionProperty();
            }
            this.intend(i + 2);
            this.write(prop1.getName() + ":" + (prop1.getRawValue() != null ? prop1.getRawValue().toString() : ""));
            if (prop2 != null) {
                this.write("  ");
                this.writeStatus(diffProp2.getDiffStatus());
                this.write("  ");
                this.write(prop2.getName() + ":" + (prop2.getRawValue() != null ? prop2.getRawValue().toString() : ""));
            }
            this.write("\n");
        }
    }

    private DiffProperty getProperty(String name, DiffProperty[] props) {
        for (DiffProperty diffProperty : props) {
            ProjectionProperty property = diffProperty.getProjectionProperty();
            if (!property.getName().equals(name)) continue;
            return diffProperty;
        }
        return null;
    }

    private void writeStatus(DiffStatus status) {
        if (status == null) {
            return;
        }
        switch (status) {
            case ADDED: {
                this.write("+");
                break;
            }
            case REMOVED: {
                this.write("-");
                break;
            }
            case DIFFERS: {
                this.write("~");
                break;
            }
            case EQUALS: {
                this.write("=");
                break;
            }
            default: {
                this.write(" ");
            }
        }
    }

    private void intend(int in) {
        for (int i = 0; i < in; ++i) {
            this.write("  ");
        }
    }
}

