/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.test;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.openl.rules.diff.differs.ProjectionDiffer;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.hierarchy.ProjectionProperty;
import org.openl.rules.diff.test.DiffElementImpl;
import org.openl.rules.diff.test.DiffPropertyImpl;
import org.openl.rules.diff.test.DiffTreeNodeImpl;
import org.openl.rules.diff.tree.DiffElement;
import org.openl.rules.diff.tree.DiffTreeBuilder;
import org.openl.rules.diff.tree.DiffTreeNode;
import org.openl.rules.diff.xls.XlsProjectionType;

public class DiffTreeBuilderImpl
implements DiffTreeBuilder {
    private ProjectionDiffer projectionDiffer;
    private int idCounter = 0;

    private String getId() {
        return "_" + this.idCounter++;
    }

    public void setProjectionDiffer(ProjectionDiffer projectionDiffer) {
        this.projectionDiffer = projectionDiffer;
    }

    public DiffTreeNode compare(Projection p1, Projection p2) {
        return this.compare(new Projection[]{p1, p2});
    }

    public DiffTreeNode compare(Projection[] projections) {
        if (projections.length < 2) {
            throw new IllegalArgumentException("At least 2 elemnts is required!");
        }
        if (this.projectionDiffer == null) {
            throw new IllegalStateException("projectionDiffer was not set!");
        }
        DiffTreeNodeImpl root = new DiffTreeNodeImpl();
        root.setId(this.getId());
        this.buildTree(root, projections);
        this.diffTree(root);
        return root;
    }

    protected void buildTree(DiffTreeNodeImpl root, Projection[] projections) {
        int len = projections.length;
        DiffElement[] diffElements = new DiffElementImpl[len];
        for (int i = 0; i < len; ++i) {
            Projection p = projections[i];
            diffElements[i] = new DiffElementImpl(p);
            for (ProjectionProperty projectionProperty : p.getProperties()) {
                diffElements[i].addDiffProperty(new DiffPropertyImpl(projectionProperty));
            }
        }
        root.setElements(diffElements);
        this.buildSubTree(root);
    }

    protected void buildSubTree(DiffTreeNodeImpl node) {
        DiffElement[] elements = node.getElements();
        int len = elements.length;
        Projection[][] children = new Projection[len][];
        for (int i = 0; i < len; ++i) {
            Projection p = elements[i].getProjection();
            children[i] = this.getChildren(p);
            if (p == null) continue;
            for (ProjectionProperty projectionProperty : p.getProperties()) {
                elements[i].addDiffProperty(new DiffPropertyImpl(projectionProperty));
            }
        }
        DiffTreeNode[] diffChildren = this.combineChildren(children);
        node.setChildren(diffChildren);
        for (DiffTreeNode child : diffChildren) {
            this.buildSubTree((DiffTreeNodeImpl)child);
        }
    }

    protected Projection[] getChildren(Projection p) {
        if (p == null) {
            return new Projection[0];
        }
        return p.getChildren();
    }

    protected DiffTreeNodeImpl[] combineChildren(Projection[][] children) {
        int len = children.length;
        TreeSet<ProjectionKey> uniqKeys = new TreeSet<ProjectionKey>();
        Map[] n2p = new HashMap[len];
        for (int i = 0; i < len; ++i) {
            HashMap<ProjectionKey, Projection> map;
            Projection[] projections = children[i];
            n2p[i] = map = new HashMap<ProjectionKey, Projection>();
            for (Projection p : projections) {
                ProjectionKey key = new ProjectionKey(p);
                map.put(key, p);
                uniqKeys.add(key);
            }
        }
        DiffTreeNodeImpl[] result = new DiffTreeNodeImpl[uniqKeys.size()];
        int i = 0;
        for (ProjectionKey key : uniqKeys) {
            DiffElement[] diffElements = new DiffElementImpl[len];
            for (int j = 0; j < len; ++j) {
                Projection p;
                p = (Projection)n2p[j].get(key);
                diffElements[j] = new DiffElementImpl(p);
            }
            result[i] = new DiffTreeNodeImpl();
            result[i].setElements(diffElements);
            result[i].setId(this.getId());
            ++i;
        }
        return result;
    }

    protected void diffTree(DiffTreeNodeImpl node) {
        DiffElementImpl first;
        DiffTreeNode[] children;
        for (DiffTreeNode child : children = node.getChildren()) {
            this.diffTree((DiffTreeNodeImpl)child);
        }
        DiffElement[] elements = node.getElements();
        int len = elements.length;
        Projection original = (first = (DiffElementImpl)elements[0]).getProjection();
        first.asOriginal(original != null);
        for (int i = 1; i < len; ++i) {
            this.compare(node, 0, i);
        }
    }

    protected void compare(DiffTreeNodeImpl node, int originalIdx, int otherIdx) {
        Projection original = node.getElement(originalIdx).getProjection();
        DiffElementImpl diff = node.getElement(otherIdx);
        Projection other = diff.getProjection();
        if (original == null) {
            if (other == null) {
                diff.asExists(true, true, true);
            } else {
                diff.asAdded();
            }
        } else if (other == null) {
            diff.asRemoved();
        } else {
            DiffTreeNode[] children;
            boolean selfEqual = this.projectionDiffer.compare(original, other);
            diff.setDiffProperties(this.projectionDiffer.getDiffProperties());
            boolean hierarhyEqual = true;
            boolean childrenEqual = true;
            for (DiffTreeNode child : children = node.getChildren()) {
                DiffElementImpl ce1 = ((DiffTreeNodeImpl)child).getElement(originalIdx);
                DiffElementImpl ce2 = ((DiffTreeNodeImpl)child).getElement(otherIdx);
                Projection p1 = ce1.getProjection();
                Projection p2 = ce2.getProjection();
                if (!ce2.isHierarhyEqual() || p1 == null || p2 == null) {
                    hierarhyEqual = false;
                    childrenEqual = false;
                    break;
                }
                if (ce2.isChildrenEqual() && ce2.isSelfEqual()) continue;
                childrenEqual = false;
            }
            diff.asExists(hierarhyEqual, childrenEqual, selfEqual);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectionKey
    implements Comparable<ProjectionKey> {
        String name;
        String type;

        ProjectionKey(Projection p) {
            this.type = p.getType();
            this.name = p.getName();
            if (this.type.equalsIgnoreCase(XlsProjectionType.CELL.name())) {
                this.name = this.name.split("-")[0].trim();
            }
        }

        @Override
        public int compareTo(ProjectionKey o) {
            int diff = this.type.compareTo(o.type);
            if (diff == 0) {
                diff = this.name.compareTo(o.name);
            }
            return diff;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ProjectionKey)) {
                return false;
            }
            ProjectionKey other = (ProjectionKey)obj;
            return this.type.equals(other.type) && this.name.equals(other.name);
        }

        public int hashCode() {
            return this.type.hashCode() * 37 + this.name.hashCode();
        }
    }
}

