/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.test;

import java.lang.reflect.Array;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.test.AbstractProjection;
import org.openl.rules.diff.test.AbstractProperty;
import org.openl.rules.diff.test.DiffTreeBuilderImpl;
import org.openl.rules.diff.test.ProjectionDifferImpl;
import org.openl.rules.diff.tree.DiffElement;
import org.openl.rules.diff.tree.DiffStatus;
import org.openl.rules.diff.tree.DiffTreeNode;

public class Test {
    public static void main(String[] args) {
        Test t = new Test();
        t.test();
    }

    void test() {
        AbstractProjection p1 = new AbstractProjection("p1", "project");
        p1.addProperty(new AbstractProperty("prop.str", String.class, "some-string"));
        p1.addProperty(new AbstractProperty("prop.date", Long.class, System.currentTimeMillis()));
        p1.addProperty(new AbstractProperty("prop.bytes[]", Array.class, new byte[]{1, 2, 3}));
        p1.addChild(new AbstractProjection("F1", "folder"));
        p1.addChild(new AbstractProjection("F2", "folder"));
        p1.addChild(new AbstractProjection("F4", "folder"));
        AbstractProjection p2 = new AbstractProjection("p2", "project");
        p2.addProperty(new AbstractProperty("prop.str", String.class, "some-string"));
        p2.addProperty(new AbstractProperty("prop.date", Long.class, System.currentTimeMillis()));
        p2.addProperty(new AbstractProperty("prop.bytes[]", Array.class, new byte[]{1, 2, 3}));
        p2.addChild(new AbstractProjection("F2", "folder"));
        p2.addChild(new AbstractProjection("F3", "folder"));
        p2.addChild(new AbstractProjection("F4", "file"));
        DiffTreeBuilderImpl builder = new DiffTreeBuilderImpl();
        builder.setProjectionDiffer(new ProjectionDifferImpl());
        DiffTreeNode tree = builder.compare(p1, p2);
        this.printTree(tree);
    }

    void printTree(DiffTreeNode root) {
        this.printR(root, 0);
    }

    void printR(DiffTreeNode node, int i) {
        this.printNode(node, i);
        for (DiffTreeNode c : node.getChildren()) {
            this.printR(c, i + 1);
        }
    }

    void printNode(DiffTreeNode node, int i) {
        this.intend(i);
        for (DiffElement e : node.getElements()) {
            DiffStatus s = e.getDiffStatus();
            switch (s) {
                case ADDED: {
                    System.out.print("+");
                    break;
                }
                case REMOVED: {
                    System.out.print("-");
                    break;
                }
                case DIFFERS: {
                    System.out.print("~");
                    break;
                }
                case EQUALS: {
                    System.out.print("=");
                    break;
                }
                default: {
                    System.out.print(" ");
                }
            }
            System.out.print(" ");
            System.out.print(e.isHierarhyEqual() ? "H" : "-");
            System.out.print(e.isChildrenEqual() ? "C" : "-");
            System.out.print(e.isSelfEqual() ? "S" : "-");
            System.out.print(" ");
            Projection p = e.getProjection();
            System.out.print(p == null ? "---" : p.getType() + ":" + p.getName());
            System.out.print("\t");
        }
        System.out.println();
    }

    private void intend(int in) {
        for (int i = 0; i < in; ++i) {
            System.out.print("  ");
        }
    }
}

