/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.util;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.hierarchy.ProjectionProperty;
import org.openl.rules.diff.tree.DiffElement;
import org.openl.rules.diff.tree.DiffTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffHelper {
    public static Object getPropValue(ProjectionProperty[] props, String propName) {
        for (ProjectionProperty prop : props) {
            if (!prop.getName().equalsIgnoreCase(propName)) continue;
            return prop.getRawValue();
        }
        return null;
    }

    public static List<DiffTreeNode> getDiffNodesByType(DiffTreeNode parent, String type) {
        DiffTreeNode[] children;
        ArrayList<DiffTreeNode> nodes = new ArrayList<DiffTreeNode>();
        for (DiffTreeNode child : children = parent.getChildren()) {
            DiffElement[] elements = child.getElements();
            Projection proj = null;
            int i = 0;
            do {
                proj = child.getElements()[i++].getProjection();
            } while (i < elements.length && proj == null);
            if (proj == null) continue;
            if (proj.getType().equals(type)) {
                nodes.add(child);
                continue;
            }
            nodes.addAll(DiffHelper.getDiffNodesByType(child, type));
        }
        return nodes;
    }

    public static DiffTreeNode getDiffNodeById(DiffTreeNode parent, String id) {
        if (parent != null) {
            if (id == null || id.equals(parent.getId())) {
                return parent;
            }
            for (DiffTreeNode child : parent.getChildren()) {
                DiffTreeNode found = DiffHelper.getDiffNodeById(child, id);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }
}

