/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.xls;

import java.util.TreeMap;
import org.openl.rules.diff.test.AbstractProjection;
import org.openl.rules.diff.test.AbstractProperty;
import org.openl.rules.diff.xls.XlsProjectionType;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeAdapter;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.ITable;
import org.openl.rules.table.syntax.GridLocation;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.source.IOpenSourceCodeModule;

public class XlsProjectionBuilder {
    public static AbstractProjection build(XlsMetaInfo xmi, String xlsName) {
        TableSyntaxNode[] nodes;
        AbstractProjection projection = new AbstractProjection(xlsName, XlsProjectionType.BOOK.name());
        XlsModuleSyntaxNode xsn = xmi.getXlsModuleNode();
        TreeMap<String, AbstractProjection> sheetProjections = new TreeMap<String, AbstractProjection>();
        for (TableSyntaxNode node : nodes = xsn.getXlsTableSyntaxNodes()) {
            TableSyntaxNodeAdapter table;
            String header;
            IOpenSourceCodeModule sheet = node.getModule();
            String sheetName = ((XlsSheetSourceCodeModule)sheet).getSheetName();
            AbstractProjection sheetProjection = (AbstractProjection)sheetProjections.get(sheetName);
            if (sheetProjection == null) {
                sheetProjection = new AbstractProjection(sheetName, XlsProjectionType.SHEET.name());
                sheetProjections.put(sheetName, sheetProjection);
            }
            String tableName = (header = (table = new TableSyntaxNodeAdapter(node)).getGridTable().getCell(0, 0).getStringValue()) == null ? "" : header;
            GridLocation location = node.getGridLocation();
            tableName = tableName + " (" + location.getStart() + ":" + location.getEnd() + ")";
            sheetProjection.addChild(XlsProjectionBuilder.buildTable((ITable)table, tableName));
        }
        for (AbstractProjection sheetProjection : sheetProjections.values()) {
            projection.addChild(sheetProjection);
        }
        return projection;
    }

    public static AbstractProjection buildTable(ITable table, String tableName) {
        AbstractProjection projection = new AbstractProjection(tableName, XlsProjectionType.TABLE.name());
        AbstractProperty grid = new AbstractProperty("grid", ITable.class, table, false);
        projection.addProperty(grid);
        IGridTable gridTable = table.getGridTable();
        int height = gridTable.getGridHeight();
        int width = gridTable.getGridWidth();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                ICell cell = gridTable.getCell(j, i);
                Object cellValue = cell.getObjectValue();
                projection.addChild(XlsProjectionBuilder.buildCell(cell, i + "x" + j + " - " + (cellValue == null ? "" : cellValue)));
            }
        }
        return projection;
    }

    public static AbstractProjection buildRow(ILogicalTable row, String rowName) {
        AbstractProjection projection = new AbstractProjection(rowName, XlsProjectionType.ROW.name());
        IGridTable grid = row.getGridTable();
        int height = grid.getGridHeight();
        int width = grid.getGridWidth();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                ICell cell = grid.getCell(j, i);
                Object cellValue = cell.getObjectValue();
                projection.addChild(XlsProjectionBuilder.buildCell(cell, i + "x" + j + " - " + (cellValue == null ? "" : cellValue)));
            }
        }
        return projection;
    }

    public static AbstractProjection buildCell(ICell cell, String cellName) {
        Object cellValue = cell.getObjectValue();
        AbstractProjection projection = new AbstractProjection(cellName, XlsProjectionType.CELL.name());
        projection.addProperty(new AbstractProperty(XlsProjectionType.CELL_VALUE.name(), cellValue != null ? cellValue.getClass() : null, cellValue));
        AbstractProperty cellProp = new AbstractProperty("cell", ICell.class, cell, false);
        projection.addProperty(cellProp);
        return projection;
    }

    public static AbstractProjection buildCellStyle(ICellStyle style) {
        return new AbstractProjection("style", XlsProjectionType.CELL_STYLE.name());
    }

    public static AbstractProjection buildCellFont(ICellFont font) {
        return new AbstractProjection("font", XlsProjectionType.CELL_FONT.name());
    }
}

