/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.differs;

import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeResult {
    String[] common;
    String[] added;
    String[] removed;

    public MergeResult(String[] common, String[] added, String[] removed) {
        this.common = common;
        this.added = added;
        this.removed = removed;
    }

    public MergeResult(Set<String> common, Set<String> added, Set<String> removed) {
        this(MergeResult.toSA(common), MergeResult.toSA(added), MergeResult.toSA(removed));
    }

    public static MergeResult mergeNames(Set<String> original, Set<String> others) {
        TreeSet<String> common = new TreeSet<String>();
        TreeSet<String> originalOnly = new TreeSet<String>();
        TreeSet<String> othersOnly = new TreeSet<String>();
        for (String s : original) {
            if (others.contains(s)) {
                common.add(s);
                continue;
            }
            originalOnly.add(s);
        }
        for (String s : others) {
            if (original.contains(s)) continue;
            othersOnly.add(s);
        }
        return new MergeResult(common, othersOnly, originalOnly);
    }

    public String[] getCommon() {
        return this.common;
    }

    public String[] getAdded() {
        return this.added;
    }

    public String[] getRemoved() {
        return this.removed;
    }

    static String[] toSA(Set<String> set) {
        return set.toArray(new String[set.size()]);
    }
}

