/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.openl.rules.diff.differs.ProjectionDiffer;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.tree.DiffElement;
import org.openl.rules.diff.tree.DiffElementImpl;
import org.openl.rules.diff.tree.DiffTreeBuilder;
import org.openl.rules.diff.tree.DiffTreeNode;
import org.openl.rules.diff.tree.DiffTreeNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffTreeBuilderImpl
implements DiffTreeBuilder {
    private ProjectionDiffer projectionDiffer;

    public void setProjectionDiffer(ProjectionDiffer projectionDiffer) {
        this.projectionDiffer = projectionDiffer;
    }

    @Override
    public DiffTreeNode compare(Projection p1, Projection p2) {
        return this.compare(new Projection[]{p1, p2});
    }

    @Override
    public DiffTreeNode compare(Projection[] projections) {
        if (projections.length < 2) {
            throw new IllegalArgumentException("At least 2 elements are required!");
        }
        if (this.projectionDiffer == null) {
            throw new IllegalStateException("projectionDiffer was not set!");
        }
        DiffTreeNodeImpl root = new DiffTreeNodeImpl();
        this.buildTree(root, projections);
        this.diffTree(root);
        return root;
    }

    protected void buildTree(DiffTreeNodeImpl root, Projection[] projections) {
        int len = projections.length;
        DiffElement[] diffElements = new DiffElementImpl[len];
        for (int i = 0; i < len; ++i) {
            Projection p = projections[i];
            diffElements[i] = new DiffElementImpl(p);
        }
        root.setElements(diffElements);
        this.buildSubTree(root);
    }

    protected void buildSubTree(DiffTreeNodeImpl node) {
        DiffElement[] elements = node.getElements();
        int len = elements.length;
        List[] children = new List[len];
        for (int i = 0; i < len; ++i) {
            Projection p = elements[i].getProjection();
            children[i] = this.getChildren(p);
        }
        List<DiffTreeNode> diffChildren = this.combineChildren(children);
        node.setChildren(diffChildren);
        for (DiffTreeNode child : diffChildren) {
            this.buildSubTree((DiffTreeNodeImpl)child);
        }
    }

    protected List<Projection> getChildren(Projection p) {
        if (p == null) {
            return Collections.EMPTY_LIST;
        }
        return p.getChildren();
    }

    protected List<DiffTreeNode> combineChildren(List<Projection>[] children) {
        int len = children.length;
        TreeSet<ProjectionKey> uniqKeys = new TreeSet<ProjectionKey>();
        HashMap[] n2p = new HashMap[len];
        for (int i = 0; i < len; ++i) {
            HashMap<ProjectionKey, Projection> map;
            n2p[i] = map = new HashMap<ProjectionKey, Projection>();
            for (Projection p : children[i]) {
                ProjectionKey key = new ProjectionKey(p);
                map.put(key, p);
                uniqKeys.add(key);
            }
        }
        ArrayList<DiffTreeNode> result = new ArrayList<DiffTreeNode>(uniqKeys.size());
        for (ProjectionKey key : uniqKeys) {
            DiffElement[] diffElements = new DiffElementImpl[len];
            for (int j = 0; j < len; ++j) {
                Projection p = (Projection)n2p[j].get(key);
                diffElements[j] = new DiffElementImpl(p);
            }
            DiffTreeNodeImpl node = new DiffTreeNodeImpl();
            node.setElements(diffElements);
            result.add(node);
        }
        return result;
    }

    protected void diffTree(DiffTreeNodeImpl node) {
        DiffElementImpl first;
        List<DiffTreeNode> children = node.getChildren();
        for (DiffTreeNode child : children) {
            this.diffTree((DiffTreeNodeImpl)child);
        }
        DiffElement[] elements = node.getElements();
        int len = elements.length;
        Projection original = (first = (DiffElementImpl)elements[0]).getProjection();
        first.asOriginal(original != null);
        for (int i = 1; i < len; ++i) {
            this.compare(node, 0, i);
        }
    }

    protected void compare(DiffTreeNodeImpl node, int originalIdx, int otherIdx) {
        Projection original = node.getElement(originalIdx).getProjection();
        DiffElementImpl diff = (DiffElementImpl)node.getElement(otherIdx);
        Projection other = diff.getProjection();
        if (original == null) {
            if (other == null) {
                diff.asExists(true, true, true);
            } else {
                diff.asAdded();
            }
        } else if (other == null) {
            diff.asRemoved();
        } else {
            boolean selfEqual = this.projectionDiffer.compare(original, other);
            boolean hierarhyEqual = true;
            boolean childrenEqual = true;
            for (DiffTreeNode child : node.getChildren()) {
                DiffElement ce1 = child.getElement(originalIdx);
                DiffElement ce2 = child.getElement(otherIdx);
                Projection p1 = ce1.getProjection();
                Projection p2 = ce2.getProjection();
                if (!ce2.isHierarhyEqual() || p1 == null || p2 == null) {
                    hierarhyEqual = false;
                    childrenEqual = false;
                    break;
                }
                if (ce2.isChildrenEqual() && ce2.isSelfEqual()) continue;
                childrenEqual = false;
            }
            diff.asExists(hierarhyEqual, childrenEqual, selfEqual);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectionKey
    implements Comparable<ProjectionKey> {
        String name;
        String type;

        ProjectionKey(Projection p) {
            this.name = p.getName();
            this.type = p.getType();
        }

        @Override
        public int compareTo(ProjectionKey o) {
            int diff = this.type.compareTo(o.type);
            if (diff == 0) {
                diff = this.name.compareTo(o.name);
            }
            return diff;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ProjectionKey)) {
                return false;
            }
            ProjectionKey other = (ProjectionKey)obj;
            return this.type.equals(other.type) && this.name.equals(other.name);
        }

        public int hashCode() {
            return this.type.hashCode() * 37 + this.name.hashCode();
        }
    }
}

