/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.Serializable;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.workspace.deploy.DeployID;

public class DeploymentInfo
implements Serializable {
    private static final long serialVersionUID = 5284876042162952913L;
    private static final char SEPARATOR = '#';
    private String name;
    private CommonVersionImpl version;

    public static DeploymentInfo valueOf(String deployment) {
        DeploymentInfo parsedDeploymentInfo = null;
        if (deployment != null) {
            int separatorPosition = deployment.lastIndexOf(35);
            parsedDeploymentInfo = separatorPosition < 0 ? new DeploymentInfo(deployment, null) : new DeploymentInfo(deployment.substring(0, separatorPosition), deployment.substring(separatorPosition + 1));
        }
        return parsedDeploymentInfo;
    }

    private DeploymentInfo(String name, String version) {
        this.name = name;
        this.version = new CommonVersionImpl(version);
    }

    public DeployID getDeployID() {
        return new DeployID(this.name + '#' + this.version.getVersionName());
    }

    public String getName() {
        return this.name;
    }

    public CommonVersionImpl getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentInfo)) {
            return false;
        }
        DeploymentInfo that = (DeploymentInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.version != null && !this.version.equals((Object)that.version)) {
            return false;
        }
        return this.version != null || that.version == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

