/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.SmartProps;
import org.openl.rules.repository.RDeploymentListener;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.ruleservice.loader.DeploymentInfo;
import org.openl.rules.ruleservice.loader.DeploymentsToLoadManager;
import org.openl.rules.ruleservice.loader.LoadingEventObject;
import org.openl.rules.ruleservice.loader.LoadingListener;
import org.openl.rules.ruleservice.loader.RulesLoader;
import org.openl.rules.workspace.lw.impl.FolderHelper;
import org.openl.rules.workspace.production.client.JcrRulesClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrRulesLoader
implements RulesLoader,
RDeploymentListener {
    private static final Log LOG = LogFactory.getLog(JcrRulesLoader.class);
    private JcrRulesClient rulesClient;
    private String folderToLoadIn;
    private DeploymentsToLoadManager deploymentsToLoadManager;
    private File folderToLoadDeploymentsIn;
    private ArrayList<LoadingListener> loadingListeners = new ArrayList();

    public JcrRulesLoader(JcrRulesClient jcrRulesClient) throws RRepositoryException {
        this.setRulesClient(jcrRulesClient);
        this.getFolderToLoadDeploymentsIn();
    }

    public JcrRulesLoader(JcrRulesClient jcrRulesClient, String theFolderToLoadIn) throws RRepositoryException {
        this.setRulesClient(jcrRulesClient);
        this.folderToLoadIn = theFolderToLoadIn;
    }

    public DeploymentsToLoadManager getDeploymentsToLoadManager() {
        return this.deploymentsToLoadManager;
    }

    public void setDeploymentsToLoadManager(DeploymentsToLoadManager deploymentsToLoadManager) {
        this.deploymentsToLoadManager = deploymentsToLoadManager;
    }

    public void projectsAdded() {
        this.loadRules();
    }

    @Override
    public synchronized void loadRules() {
        try {
            Collection deploymentNames = this.rulesClient.getDeploymentNames();
            Collection<DeploymentInfo> deployments = JcrRulesLoader.parseDeloyments(deploymentNames);
            Collection<DeploymentInfo> deploymentsToLoad = this.deploymentsToLoadManager.getDeploymentsToLoad(deployments);
            for (DeploymentInfo deployment : deploymentsToLoad) {
                this.load(deployment);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception loading new items", (Throwable)e);
        }
    }

    public void resetLoadedDeploymentsCache() {
        if (this.deploymentsToLoadManager != null) {
            this.deploymentsToLoadManager.resetLoadedDeploymentsCache();
        }
    }

    @Override
    public synchronized void load(DeploymentInfo di) throws Exception {
        LOG.debug((Object)String.format("Start loading deployment \"%s\"", this.getDeploymentFolderName(di)));
        this.onBeforeLoading(di);
        try {
            File deploymentLocalFolder = this.downloadDeployment(di);
            LOG.info((Object)String.format("Loaded deployment \"%s\" at %s", this.getDeploymentFolderName(di), deploymentLocalFolder.getAbsolutePath()));
            this.onAfterLoading(di, deploymentLocalFolder);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to load deployment project " + di.getDeployID()), (Throwable)e);
            throw e;
        }
    }

    public void resetFolderToLoadDeploymentsIn() {
        this.folderToLoadDeploymentsIn = null;
    }

    static Collection<DeploymentInfo> parseDeloyments(Collection<String> deploymentNames) {
        ArrayList<DeploymentInfo> deployments = new ArrayList<DeploymentInfo>();
        for (String deploymentName : deploymentNames) {
            DeploymentInfo di = DeploymentInfo.valueOf(deploymentName);
            if (di == null) continue;
            deployments.add(di);
        }
        return deployments;
    }

    private File downloadDeployment(DeploymentInfo di) throws Exception {
        File deploymentFolder = new File(this.getFolderToLoadDeploymentsIn(), this.getDeploymentFolderName(di));
        this.rulesClient.fetchDeployment(di.getDeployID(), deploymentFolder);
        return deploymentFolder;
    }

    private String getDeploymentFolderName(DeploymentInfo di) {
        return String.format("%s_v%s", di.getName(), di.getVersion().getVersionName());
    }

    private void setRulesClient(JcrRulesClient rulesJcrClient) throws RRepositoryException {
        this.rulesClient = rulesJcrClient;
        final JcrRulesLoader loader = this;
        this.rulesClient.addListener((RDeploymentListener)loader);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    JcrRulesLoader.this.rulesClient.removeListener((RDeploymentListener)loader);
                }
                catch (RRepositoryException e) {
                    // empty catch block
                }
                try {
                    JcrRulesLoader.this.rulesClient.release();
                }
                catch (RRepositoryException rRepositoryException) {
                    // empty catch block
                }
            }
        }));
    }

    protected String getTempDirectory() {
        SmartProps props = new SmartProps("rules-production.properties");
        String value = props.getStr("ruleservice.tmp.dir");
        if (value == null || value.trim().length() == 0) {
            return "/tmp/rules-deploy";
        }
        return value;
    }

    private File getFolderToLoadDeploymentsIn() {
        if (this.folderToLoadDeploymentsIn == null) {
            if (this.folderToLoadIn == null) {
                this.folderToLoadIn = this.getTempDirectory();
            }
            this.folderToLoadDeploymentsIn = new File(this.folderToLoadIn);
            this.folderToLoadDeploymentsIn.mkdirs();
            FolderHelper.clearFolder((File)this.folderToLoadDeploymentsIn);
            this.resetLoadedDeploymentsCache();
        }
        return this.folderToLoadDeploymentsIn;
    }

    private void onAfterLoading(DeploymentInfo di, File deploymentLocalFolder) {
        Collection localCopyOfListeners = (Collection)this.loadingListeners.clone();
        for (LoadingListener loadingListener : localCopyOfListeners) {
            loadingListener.onAfterLoading(new LoadingEventObject(this, di, deploymentLocalFolder));
        }
    }

    private void onBeforeLoading(DeploymentInfo di) {
        Collection localCopyOfListeners = (Collection)this.loadingListeners.clone();
        for (LoadingListener loadingListener : localCopyOfListeners) {
            loadingListener.onBeforeLoading(new LoadingEventObject(this, di));
        }
    }

    @Override
    public void addLoadingListener(LoadingListener loadingListener) {
        if (loadingListener != null) {
            this.loadingListeners.add(loadingListener);
        }
    }

    @Override
    public void removeLoadingListener(LoadingListener loadingListener) {
        this.loadingListeners.remove(loadingListener);
    }
}

