/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.ruleservice.loader.DeploymentInfo;
import org.openl.rules.ruleservice.loader.DeploymentsToLoadManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatestDeploymentsToLoadManager
implements DeploymentsToLoadManager {
    private Map<String, String> deployment2Version = new HashMap<String, String>();

    @Override
    public Collection<DeploymentInfo> getDeploymentsToLoad(Collection<DeploymentInfo> deployments) {
        Map<String, CommonVersion> latestVersionMap = LatestDeploymentsToLoadManager.computeLatestVersions(deployments);
        Collection<DeploymentInfo> deploymentsToLoad = this.computeDeploymentsToLoad(deployments, latestVersionMap);
        for (DeploymentInfo deployment : deploymentsToLoad) {
            this.deployment2Version.put(deployment.getName(), deployment.getVersion().getVersionName());
        }
        return deploymentsToLoad;
    }

    @Override
    public void resetLoadedDeploymentsCache() {
        this.deployment2Version = new HashMap<String, String>();
    }

    public static Map<String, CommonVersion> computeLatestVersions(Collection<DeploymentInfo> deployments) {
        HashMap<String, CommonVersion> versionMap = new HashMap<String, CommonVersion>();
        for (DeploymentInfo deployment : deployments) {
            CommonVersion version = (CommonVersion)versionMap.get(deployment.getName());
            if (version == null || deployment.getVersion().compareTo(version) > 0) {
                version = deployment.getVersion();
            }
            versionMap.put(deployment.getName(), version);
        }
        return versionMap;
    }

    private Collection<DeploymentInfo> computeDeploymentsToLoad(Collection<DeploymentInfo> deployments, Map<String, CommonVersion> latestVersionMap) {
        ArrayList<DeploymentInfo> deploymentsToLoad = new ArrayList<DeploymentInfo>();
        for (DeploymentInfo deployment : deployments) {
            String version;
            if (!latestVersionMap.get(deployment.getName()).equals(deployment.getVersion()) || (version = deployment.getVersion().getVersionName()).equals(this.deployment2Version.get(deployment.getName()))) continue;
            deploymentsToLoad.add(deployment);
        }
        return deploymentsToLoad;
    }
}

