/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.main.OpenLWrapper;
import org.openl.rules.project.instantiation.ReloadType;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationStrategyFactory;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.ruleservice.publish.DeploymentAdmin;
import org.openl.rules.ruleservice.publish.DeploymentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassDeploymentAdmin
implements DeploymentAdmin {
    private static final Log log = LogFactory.getLog(JavaClassDeploymentAdmin.class);
    private Map<String, Map<String, OpenLWrapper>> runningServices = new HashMap<String, Map<String, OpenLWrapper>>();
    private Collection<DeploymentListener> deploymentListeners = new ArrayList<DeploymentListener>();

    public void addDeploymentListener(DeploymentListener deploymentListener) {
        if (deploymentListener != null) {
            this.deploymentListeners.add(deploymentListener);
        }
    }

    @Override
    public synchronized void deploy(String deploymentName, List<ProjectDescriptor> infoList) {
        this.onBeforeDeployment(deploymentName);
        this.undeploy(deploymentName);
        HashMap<String, OpenLWrapper> projectWrappers = new HashMap<String, OpenLWrapper>();
        for (ProjectDescriptor wsInfo : infoList) {
            for (Module rulesModule : wsInfo.getModules()) {
                try {
                    OpenLWrapper wrapper = this.deploy(deploymentName, rulesModule);
                    projectWrappers.put(rulesModule.getName(), wrapper);
                }
                catch (Exception e) {
                    log.error((Object)"failed to create service", (Throwable)e);
                }
            }
        }
        this.runningServices.put(deploymentName, projectWrappers);
        log.info((Object)String.format("Deployed \"%s\" ", deploymentName));
        this.onAfterDeployment(deploymentName, projectWrappers);
    }

    private OpenLWrapper deploy(String serviceName, Module rulesModule) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        RulesInstantiationStrategy strategy = RulesInstantiationStrategyFactory.getStrategy((Module)rulesModule, (boolean)true);
        return (OpenLWrapper)strategy.instantiate(ReloadType.SINGLE);
    }

    private void onAfterDeployment(String deploymentName, Map<String, OpenLWrapper> projectWrappers) {
        for (DeploymentListener deploymentListener : this.deploymentListeners) {
            deploymentListener.afterDeployment(deploymentName, projectWrappers);
        }
    }

    private void onAfterUndeployment(String deploymentName) {
        for (DeploymentListener deploymentListener : this.deploymentListeners) {
            deploymentListener.afterUndeployment(deploymentName);
        }
    }

    private void onBeforeDeployment(String deploymentName) {
        for (DeploymentListener deploymentListener : this.deploymentListeners) {
            deploymentListener.beforeDeployment(deploymentName);
        }
    }

    private void onBeforeUndeployment(String deploymentName) {
        for (DeploymentListener deploymentListener : this.deploymentListeners) {
            deploymentListener.beforeUndeployment(deploymentName);
        }
    }

    public void removeDeploymentListener(DeploymentListener deploymentListener) {
        this.deploymentListeners.remove(deploymentListener);
    }

    @Override
    public synchronized void undeploy(String deploymentName) {
        this.onBeforeUndeployment(deploymentName);
        this.runningServices.remove(deploymentName);
        this.onAfterUndeployment(deploymentName);
    }
}

