/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.RulesProjectResolver;
import org.openl.rules.ruleservice.loader.DeploymentInfo;
import org.openl.rules.ruleservice.publish.DeploymentAdmin;
import org.openl.rules.ruleservice.publish.ServiceNameBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesPublisher {
    private final Log log = LogFactory.getLog(this.getClass());
    private DeploymentAdmin deployAdmin;
    private RulesProjectResolver rulesProjectResolver = RulesProjectResolver.loadProjectResolverFromClassPath();
    private ServiceNameBuilder serviceNameBuilder;

    private List<ProjectDescriptor> resolveProjects(File deploymentLocalFolder) {
        this.rulesProjectResolver.setWorkspace(deploymentLocalFolder.getAbsolutePath());
        return this.rulesProjectResolver.listOpenLProjects();
    }

    public synchronized void deploy(DeploymentInfo di, File deploymentLocalFolder) {
        try {
            List<ProjectDescriptor> serviceClasses = this.resolveProjects(deploymentLocalFolder);
            String serviceName = this.serviceNameBuilder.getServiceName(di);
            this.deployAdmin.deploy(serviceName, serviceClasses);
        }
        catch (Exception e) {
            this.log.error((Object)String.format("Failed to deploy project \"%s\"", di.getDeployID()), (Throwable)e);
        }
    }

    public synchronized void undeploy(DeploymentInfo di) {
        this.deployAdmin.undeploy(di.getName());
    }

    public void setDeployAdmin(DeploymentAdmin deployAdmin) {
        this.deployAdmin = deployAdmin;
    }

    public DeploymentAdmin getDeployAdmin() {
        return this.deployAdmin;
    }

    public synchronized void setRulesProjectResolver(RulesProjectResolver rulesProjectResolver) {
        this.rulesProjectResolver = rulesProjectResolver;
    }

    public ServiceNameBuilder getServiceNameBuilder() {
        return this.serviceNameBuilder;
    }

    public void setServiceNameBuilder(ServiceNameBuilder serviceNameBuilder) {
        this.serviceNameBuilder = serviceNameBuilder;
    }
}

