/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.simple;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.main.OpenLWrapper;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.ruleservice.RuleService;
import org.openl.rules.ruleservice.loader.JcrRulesLoader;
import org.openl.rules.ruleservice.publish.DeploymentListener;
import org.openl.rules.ruleservice.publish.JavaClassDeploymentAdmin;
import org.openl.rules.ruleservice.publish.RulesPublisher;
import org.openl.rules.ruleservice.simple.RulesFrontend;
import org.openl.rules.workspace.production.client.JcrRulesClient;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.SimpleVM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesFrontendImpl
extends RuleService
implements RulesFrontend {
    private static final Log LOG = LogFactory.getLog(RulesFrontendImpl.class);
    private Thread frontendExecutor;
    private Map<String, Map<String, OpenLWrapper>> runningDeployments = new HashMap<String, Map<String, OpenLWrapper>>();

    public RulesFrontendImpl() {
        this.init();
        this.startFrontend();
    }

    public void close() {
        if (!this.frontendExecutor.isInterrupted()) {
            this.frontendExecutor.interrupt();
        }
    }

    @Override
    public Object execute(String deployment, String ruleModule, String ruleName, Class<?>[] inputParamsTypes, Object[] params) {
        OpenLWrapper wrapper;
        Object result = null;
        if (this.runningDeployments.containsKey(deployment) && (wrapper = this.runningDeployments.get(deployment).get(ruleModule)) != null) {
            IOpenClass[] methodParamTypes = new IOpenClass[inputParamsTypes.length];
            for (int i = 0; i < inputParamsTypes.length; ++i) {
                methodParamTypes[i] = JavaOpenClass.getOpenClass(inputParamsTypes[i]);
            }
            IOpenClass openlClass = wrapper.getCompiledOpenClass().getOpenClassWithErrors();
            IOpenMethod openlMethod = openlClass.getMatchingMethod(ruleName, methodParamTypes);
            if (openlMethod != null) {
                result = openlMethod.invoke(wrapper.getInstance(), params, new SimpleVM().getRuntimeEnv());
            }
        }
        return result;
    }

    @Override
    public Object execute(String deployment, String ruleModule, String ruleName, Object ... params) {
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        return this.execute(deployment, ruleModule, ruleName, paramTypes, params);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public Object getValues(String deployment, String ruleModule, String fieldName) {
        IOpenClass openlClass;
        IOpenField openlField;
        OpenLWrapper wrapper;
        Object result = null;
        if (this.runningDeployments.containsKey(deployment) && (wrapper = this.runningDeployments.get(deployment).get(ruleModule)) != null && (openlField = (openlClass = wrapper.getCompiledOpenClass().getOpenClassWithErrors()).getField(fieldName)) != null) {
            result = openlField.get(wrapper.getInstance(), new SimpleVM().getRuntimeEnv());
        }
        return result;
    }

    private void init() {
        try {
            this.loader = new JcrRulesLoader(new JcrRulesClient());
        }
        catch (RRepositoryException e) {
            LOG.error((Object)"Failed to intialize rules loader from JCR.", (Throwable)e);
        }
        this.publisher = new RulesPublisher();
        JavaClassDeploymentAdmin deploymentAdmin = new JavaClassDeploymentAdmin();
        DeploymentListener deploymentListener = new DeploymentListener(){

            @Override
            public void afterDeployment(String deploymentName, Map<String, OpenLWrapper> ruleModules) {
                RulesFrontendImpl.this.registerProjects(deploymentName, ruleModules);
            }

            @Override
            public void afterUndeployment(String deploymentName) {
            }

            @Override
            public void beforeDeployment(String deploymentName) {
            }

            @Override
            public void beforeUndeployment(String deploymentName) {
                RulesFrontendImpl.this.unregisterProjects(deploymentName);
            }
        };
        deploymentAdmin.addDeploymentListener(deploymentListener);
        this.publisher.setDeployAdmin(deploymentAdmin);
    }

    protected void registerProjects(String deploymentName, Map<String, OpenLWrapper> ruleModules) {
        this.runningDeployments.put(deploymentName, ruleModules);
        LOG.info((Object)String.format("Started exposing deployment \"%s\" with rules modules %s", deploymentName, ruleModules.keySet().toString()));
    }

    private void startFrontend() {
        this.frontendExecutor = new Thread(this);
        this.frontendExecutor.setDaemon(true);
        this.frontendExecutor.start();
    }

    protected void unregisterProjects(String deploymentName) {
        this.runningDeployments.remove(deploymentName);
        LOG.info((Object)String.format("Stoped exposing deployment \"%s\" ", deploymentName));
    }
}

