/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.ClassUtils;
import org.openl.util.ASelector;
import org.openl.util.IConvertor;
import org.openl.util.ISelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTool {
    public static final Object[] ZERO_OBJECT = new Object[0];
    public static final Class<?>[] ZERO_CLASS = new Class[0];
    public static final String[] ZERO_STRING = new String[0];
    public static final int[] ZERO_int = new int[0];
    public static final char[] ZERO_char = new char[0];

    public static Object add(Object array, Object value) {
        return ArrayTool.insertValue(Array.getLength(array), array, value);
    }

    public static String asString(Object ary) {
        return ArrayTool.asString(ary, 128);
    }

    public static String asString(Object ary, int maxLength) {
        StringBuffer buf = new StringBuffer(100);
        ArrayTool.print(ary, buf, maxLength);
        if (buf.length() > maxLength) {
            String ellipses = "...";
            buf.delete(maxLength - ellipses.length(), buf.length()).append(ellipses);
        }
        return buf.toString();
    }

    public static <DST, SRC> DST[] collect(SRC[] src, Class<DST> dstType, IConvertor<SRC, DST> c) {
        int size = src.length;
        Object[] dstArray = (Object[])Array.newInstance(dstType, size);
        for (int i = 0; i < size; ++i) {
            Array.set(dstArray, i, c.convert(src[i]));
        }
        return dstArray;
    }

    public static boolean contains(Object array, Object test) {
        return ArrayTool.findFirstElementIndex(array, test) >= 0;
    }

    public static <T> boolean containsAll(T[] container, T[] testArray) {
        Iterator<T> it = ArrayTool.iterator(testArray);
        while (it.hasNext()) {
            if (ArrayTool.contains(container, it.next())) continue;
            return false;
        }
        return true;
    }

    public static Object copy(Object oldArray) {
        int size = Array.getLength(oldArray);
        Object newArray = Array.newInstance(oldArray.getClass().getComponentType(), size);
        System.arraycopy(oldArray, 0, newArray, 0, size);
        return newArray;
    }

    public static int dimensionOfArray(Object ary, Class<?> baseClass) {
        Class<?> aryClass = ary.getClass();
        int dim = 0;
        while (aryClass != baseClass && aryClass.isArray()) {
            aryClass = aryClass.getComponentType();
            ++dim;
        }
        return aryClass == baseClass ? dim : -1;
    }

    public static Object ensureSize(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        if (oldSize >= newSize) {
            return oldArray;
        }
        Class<?> componentType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newSize);
        System.arraycopy(oldArray, 0, newArray, 0, oldSize);
        return newArray;
    }

    public static Enumeration<Object> enumeration(Object array) {
        return new ArrayEnumeration(array);
    }

    public static boolean equals(Object obj1, Object obj2) {
        Class<?> c2;
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        Class<?> c1 = obj1.getClass();
        if (c1 != (c2 = obj2.getClass())) {
            return false;
        }
        if (c1.isArray()) {
            int size2;
            int size1 = ArrayTool.size(obj1);
            if (size1 != (size2 = ArrayTool.size(obj2))) {
                return false;
            }
            for (int i = 0; i < size1; ++i) {
                if (ArrayTool.equals(Array.get(obj1, i), Array.get(obj2, i))) continue;
                return false;
            }
            return true;
        }
        return obj1.equals(obj2);
    }

    public static Object findFirstElement(Object array, ISelector<Object> s) {
        int index = ArrayTool.findFirstIndex(array, s);
        if (index < 0) {
            return null;
        }
        return Array.get(array, index);
    }

    public static int findFirstElementIndex(Object array, Object element) {
        return ArrayTool.findFirstIndex(array, ASelector.selectObject(element));
    }

    public static int findFirstIndex(Object array, ISelector<Object> sel) {
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            if (!sel.select(Array.get(array, i))) continue;
            return i;
        }
        return -1;
    }

    public static Class<?> getArrayClass(Class<?> componentType, int dimensions) {
        if (dimensions == 0) {
            return componentType;
        }
        int[] dims = new int[dimensions];
        return Array.newInstance(componentType, dims).getClass();
    }

    public static <T> boolean haveSameElements(T[] array1, T[] array2) {
        return ArrayTool.containsAll(array1, array2) && ArrayTool.containsAll(array2, array1);
    }

    public static Object insertValue(int i, Object oldArray, Object value) {
        int oldSize = Array.getLength(oldArray);
        Object newArray = Array.newInstance(oldArray.getClass().getComponentType(), oldSize + 1);
        if (i > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, i);
        }
        Array.set(newArray, i, value);
        if (i < oldSize) {
            System.arraycopy(oldArray, i, newArray, i + 1, oldSize - i);
        }
        return newArray;
    }

    public static Object insertValues(int[] indexes, Object oldArray, ArrayModel value) {
        if (indexes.length == 0) {
            return oldArray;
        }
        if (indexes.length == 1) {
            return ArrayTool.insertValue(indexes[0], oldArray, value.getObject(indexes[0]));
        }
        Arrays.sort(indexes);
        int oldSize = Array.getLength(oldArray);
        int validIndexesSize = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] > oldSize) continue;
            validIndexesSize = i + 1;
        }
        Object newArray = oldArray;
        if (validIndexesSize == 1) {
            newArray = ArrayTool.insertValue(indexes[0], oldArray, value.getObject(indexes[0]));
        } else if (validIndexesSize > 1) {
            Class<?> componentType = oldArray.getClass().getComponentType();
            newArray = Array.newInstance(componentType, oldSize + validIndexesSize);
            for (int i = 0; i < validIndexesSize; ++i) {
                int prev_i1;
                if (i == 0) {
                    if (indexes[i] > 0) {
                        System.arraycopy(oldArray, 0, newArray, 0, indexes[i]);
                    }
                } else if (i == validIndexesSize - 1) {
                    prev_i1 = indexes[i - 1];
                    if (prev_i1 < indexes[i]) {
                        System.arraycopy(oldArray, prev_i1, newArray, prev_i1 + i, indexes[i] - prev_i1);
                    }
                    if (indexes[i] < oldSize) {
                        System.arraycopy(oldArray, indexes[i], newArray, indexes[i] + i + 1, oldSize - indexes[i]);
                    }
                } else {
                    prev_i1 = indexes[i - 1];
                    if (prev_i1 < indexes[i]) {
                        System.arraycopy(oldArray, prev_i1, newArray, prev_i1 + i, indexes[i] - prev_i1);
                    }
                }
                Array.set(newArray, indexes[i] + i, value.getObject(indexes[i]));
            }
        }
        return newArray;
    }

    public static <T> boolean intersects(T[] array1, T[] array2) {
        Iterator<T> it = ArrayTool.iterator(array1);
        while (it.hasNext()) {
            if (!ArrayTool.contains(array2, it.next())) continue;
            return true;
        }
        return false;
    }

    public static <T> Iterator<T> iterator(T[] array) {
        return new ArrayIterator<T>(array);
    }

    public static Object merge(Object array1, Object array2) {
        return ArrayTool.merge(new Object[]{array1, array2});
    }

    public static Object merge(Object[] arrays) {
        if (arrays == null || arrays.length == 0) {
            return new Object[0];
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        int newSize = 0;
        for (int i = 0; i < arrays.length; ++i) {
            newSize += Array.getLength(arrays[i]);
        }
        if (newSize == Array.getLength(arrays[0])) {
            return arrays[0];
        }
        Object newArray = Array.newInstance(arrays[0].getClass().getComponentType(), newSize);
        int pos = 0;
        for (int i = 0; i < arrays.length; ++i) {
            int sz = Array.getLength(arrays[i]);
            System.arraycopy(arrays[i], 0, newArray, pos, sz);
            pos += Array.getLength(arrays[i]);
        }
        return newArray;
    }

    public static void move(Object array, int index, int delta) {
        Object value = Array.get(array, index);
        if (delta > 0) {
            for (int i = 0; i < delta; ++i) {
                Object newValue = Array.get(array, index + i + 1);
                Array.set(array, index + i, newValue);
            }
        } else if (delta < 0) {
            for (int i = 0; i > delta; --i) {
                Object newValue = Array.get(array, index + i - 1);
                Array.set(array, index + i, newValue);
            }
        }
        Array.set(array, index + delta, value);
    }

    static void print(Object obj, StringBuffer buf, int maxLength) {
        if (obj == null) {
            buf.append("null");
        } else if (obj instanceof String) {
            buf.append('\"').append(obj).append('\"');
        } else if (obj instanceof Class) {
            buf.append(((Class)obj).getName());
        } else if (obj.getClass().isArray()) {
            ArrayTool.printArray(obj, buf, maxLength);
        } else {
            buf.append(obj);
        }
    }

    static void printArray(Object ary, StringBuffer buf, int maxLength) {
        int size = Array.getLength(ary);
        buf.append('[');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            ArrayTool.print(Array.get(ary, i), buf, maxLength);
            if (buf.length() <= maxLength) continue;
            return;
        }
        buf.append(']');
    }

    public static Object remove(Object array, Object element) {
        int idx = ArrayTool.findFirstElementIndex(array, element);
        if (idx == -1) {
            return array;
        }
        return ArrayTool.removeValue(idx, array);
    }

    public static Object removeValue(int i, Object oldArray) {
        int i1;
        int oldSize = Array.getLength(oldArray);
        Object newArray = Array.newInstance(oldArray.getClass().getComponentType(), oldSize - 1);
        if (i > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, i);
        }
        if ((i1 = i + 1) < oldSize) {
            System.arraycopy(oldArray, i1, newArray, i, oldSize - i1);
        }
        return newArray;
    }

    public static Object removeValues(int[] indexes, Object oldArray) {
        if (indexes.length == 0) {
            return oldArray;
        }
        int oldSize = Array.getLength(oldArray);
        Arrays.sort(indexes);
        int validIndexesSize = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= oldSize) continue;
            validIndexesSize = i + 1;
        }
        if (validIndexesSize == 0) {
            return oldArray;
        }
        if (validIndexesSize == 1) {
            return ArrayTool.removeValue(indexes[0], oldArray);
        }
        Object newArray = Array.newInstance(oldArray.getClass().getComponentType(), oldSize - validIndexesSize);
        for (int i = 0; i < validIndexesSize; ++i) {
            int prev_i1;
            if (i == 0) {
                if (indexes[i] <= 0) continue;
                System.arraycopy(oldArray, 0, newArray, 0, indexes[i]);
                continue;
            }
            if (i == validIndexesSize - 1) {
                int i1;
                prev_i1 = indexes[i - 1] + 1;
                if (prev_i1 < indexes[i]) {
                    System.arraycopy(oldArray, prev_i1, newArray, prev_i1 - i, indexes[i] - prev_i1);
                }
                if ((i1 = indexes[i] + 1) >= oldSize) continue;
                System.arraycopy(oldArray, i1, newArray, i1 - i - 1, oldSize - i1);
                continue;
            }
            prev_i1 = indexes[i - 1] + 1;
            if (prev_i1 >= indexes[i]) continue;
            System.arraycopy(oldArray, prev_i1, newArray, prev_i1 - i, indexes[i] - prev_i1);
        }
        return newArray;
    }

    public static Object resize(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        if (oldSize == newSize) {
            return oldArray;
        }
        Class<?> componentType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newSize);
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldSize, newSize));
        return newArray;
    }

    public static int size(Object ary) {
        return Array.getLength(ary);
    }

    public static Object subarray(Object srcArray, int beginIndex, int endIndex) {
        int count = Array.getLength(srcArray) - 1;
        if (beginIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > count) {
            throw new ArrayIndexOutOfBoundsException(endIndex);
        }
        int newLength = endIndex - beginIndex + 1;
        if (newLength <= 0) {
            throw new ArrayIndexOutOfBoundsException(endIndex - beginIndex);
        }
        if (beginIndex == 0 && endIndex == count) {
            return srcArray;
        }
        Object newArray = Array.newInstance(srcArray.getClass().getComponentType(), newLength);
        System.arraycopy(srcArray, beginIndex, newArray, 0, newLength);
        return newArray;
    }

    public static void swap(Object array, int i1, int i2) {
        Object value1 = Array.get(array, i1);
        Object value2 = Array.get(array, i2);
        Array.set(array, i1, value2);
        Array.set(array, i2, value1);
    }

    public static void swap(Object array, Object value1, Object value2) {
        int i1 = ArrayTool.findFirstElementIndex(array, value1);
        int i2 = ArrayTool.findFirstElementIndex(array, value2);
        ArrayTool.swap(array, i1, i2);
    }

    public static <T> Object[] toArray(List<T> v, Class<?> c) {
        Object[] ary = (Object[])Array.newInstance(c, v.size());
        return v.toArray(ary);
    }

    public static String[] tokens(String toparse, String delim) {
        StringTokenizer st = new StringTokenizer(toparse, delim);
        ArrayList<String> v = new ArrayList<String>(10);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }

    public static Set<Object> toSet(Object[] ary) {
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < ary.length; ++i) {
            set.add(ary[i]);
        }
        return set;
    }

    public static Object zeroArray(Class<?> c) {
        if (c == String.class) {
            return ZERO_STRING;
        }
        return Array.newInstance(c, 0);
    }

    public static boolean isEmpty(Object[] array) {
        if (array != null) {
            for (Object element : array) {
                if (element == null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsAll(int[] ary1, int[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (int arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(byte[] ary1, byte[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (byte arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(short[] ary1, short[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (short arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(long[] ary1, long[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (long arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char[] ary1, char[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (char arrayElement : ary2) {
            if (ArrayTool.contains(ary1, Character.valueOf(arrayElement))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(float[] ary1, float[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (float arrayElement : ary2) {
            if (ArrayTool.contains(ary1, Float.valueOf(arrayElement))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(String[] ary1, String[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (String arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(double[] ary1, double[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (double arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(boolean[] ary1, boolean[] ary2) {
        if (ary1 == null || ary2 == null) {
            return false;
        }
        for (boolean arrayElement : ary2) {
            if (ArrayTool.contains(ary1, arrayElement)) continue;
            return false;
        }
        return true;
    }

    public static String[] intersection(String[] ary1, String[] ary2) {
        ArrayList<String> v = new ArrayList<String>();
        for (int j = 0; j < ary2.length; ++j) {
            if (!ArrayTool.contains(ary1, ary2[j])) continue;
            v.add(ary2[j]);
        }
        return v.toArray(new String[v.size()]);
    }

    public static Object[] toArray(Object object) {
        if (object == null) {
            return null;
        }
        int size = !object.getClass().isArray() ? 1 : Array.getLength(object);
        Class<Object> clazz = object.getClass().isArray() ? object.getClass().getComponentType() : object.getClass();
        Class<Object> componentType = clazz.isPrimitive() ? ClassUtils.primitiveToWrapper(clazz) : clazz;
        Object[] newArray = (Object[])Array.newInstance(componentType, size);
        for (int i = 0; i < size; ++i) {
            newArray[i] = Array.get(object, i);
        }
        return newArray;
    }

    public static interface ArrayModel {
        public Object getObject(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayIterator<T>
    implements Iterator<T> {
        int _index = 0;
        int _size;
        T[] _array;

        ArrayIterator(T[] array) {
            this._size = Array.getLength(array);
            this._array = array;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._size;
        }

        @Override
        public T next() {
            return this._array[this._index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayEnumeration
    implements Enumeration<Object> {
        int _index = 0;
        int _size;
        Object _array;

        ArrayEnumeration(Object array) {
            this._size = Array.getLength(array);
            this._array = array;
        }

        @Override
        public boolean hasMoreElements() {
            return this._index < this._size;
        }

        @Override
        public Object nextElement() {
            return Array.get(this._array, this._index++);
        }
    }
}

