/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import org.apache.commons.lang.ArrayUtils;

public class BooleanUtils {
    private static String[] additionalTrueValues = new String[]{"y", "t"};
    private static String[] additionalFalseValues = new String[]{"n", "f"};

    public static boolean toBoolean(Object value) {
        Boolean bValue = BooleanUtils.toBooleanObject(value);
        if (bValue == null) {
            return false;
        }
        return bValue;
    }

    public static Boolean toBooleanObject(Object value) {
        Boolean bValue = null;
        if (value instanceof String) {
            bValue = BooleanUtils.isAdditionalValue((String)value) ? BooleanUtils.getBooleanFromAdditionalValue((String)value) : org.apache.commons.lang.BooleanUtils.toBooleanObject((String)((String)value));
        } else if (value instanceof Integer) {
            bValue = org.apache.commons.lang.BooleanUtils.toBoolean((int)((Integer)value));
        } else if (value instanceof Boolean) {
            bValue = (Boolean)value;
        }
        return bValue;
    }

    private static Boolean getBooleanFromAdditionalValue(String value) {
        Boolean result = null;
        String lcase = value.toLowerCase().intern();
        if (ArrayUtils.contains((Object[])additionalTrueValues, (Object)lcase)) {
            result = Boolean.TRUE;
        }
        if (ArrayUtils.contains((Object[])additionalFalseValues, (Object)lcase)) {
            result = Boolean.FALSE;
        }
        return result;
    }

    private static boolean isAdditionalValue(String value) {
        String lcaseValue = value.toLowerCase().intern();
        return ArrayUtils.contains((Object[])additionalTrueValues, (Object)lcaseValue) || ArrayUtils.contains((Object[])additionalFalseValues, (Object)lcaseValue);
    }
}

