/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import org.openl.util.IdObject;

public class IdMap {
    public static final IdObjectAdaptor ID_OBJECT_ADAPTOR = new IdObjectAdaptor();
    IdAdaptor adaptor;
    double freeSpaceRatio;
    int capacityGuard;
    double growthFactor;
    int size = 0;
    Object[] data;

    public IdMap(int initialCapacity) {
        this(initialCapacity, ID_OBJECT_ADAPTOR, 1.2, 2.0);
    }

    public IdMap(int initialCapacity, IdAdaptor adaptor, double freeSpaceRatio, double growthFactor) {
        this.adaptor = adaptor;
        this.freeSpaceRatio = freeSpaceRatio;
        this.capacityGuard = initialCapacity;
        this.growthFactor = growthFactor;
        this.data = new Object[(int)((double)initialCapacity * freeSpaceRatio)];
    }

    public boolean add(Object obj) {
        return this.add(obj, true);
    }

    public synchronized boolean add(Object obj, boolean checkCapacity) {
        int id;
        int slot;
        if (checkCapacity) {
            this.checkCapacity();
        }
        if (this.data[slot = this.getIndex(id = this.adaptor.getId(obj))] != null) {
            return false;
        }
        ++this.size;
        this.data[slot] = obj;
        return true;
    }

    synchronized void checkCapacity() {
        if (this.size == this.capacityGuard) {
            this.capacityGuard = (int)((double)this.capacityGuard * this.growthFactor);
            Object[] oldData = this.data;
            this.data = new Object[(int)((double)this.capacityGuard * this.freeSpaceRatio)];
            this.size = 0;
            for (int i = 0; i < oldData.length; ++i) {
                if (oldData[i] == null) continue;
                this.add(oldData[i], false);
            }
        }
    }

    public Object get(int id) {
        int slot = this.getIndex(id);
        return this.data[slot];
    }

    public int getIndex(int id) {
        int start;
        int len = this.data.length;
        int slot = start = id % len;
        do {
            Object obj;
            if ((obj = this.data[slot]) == null) {
                return slot;
            }
            if (this.adaptor.getId(obj) != id) continue;
            return slot;
        } while ((slot = (slot + 1) % len) != start);
        return -1;
    }

    public synchronized boolean remove(int id) {
        int slot = this.getIndex(id);
        if (this.data[slot] == null) {
            return false;
        }
        this.data[slot] = null;
        --this.size;
        int len = this.data.length;
        Object obj;
        while ((obj = this.data[slot = (slot + 1) % len]) != null) {
            --this.size;
            this.data[slot] = null;
            this.add(obj, false);
        }
        return true;
    }

    public boolean remove(Object obj) {
        return this.remove(this.adaptor.getId(obj));
    }

    public int size() {
        return this.size;
    }

    public static class IdObjectAdaptor
    implements IdAdaptor {
        public int getId(Object obj) {
            return ((IdObject)obj).getId();
        }
    }

    public static interface IdAdaptor {
        public int getId(Object var1);
    }
}

