/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalMap<T, V> {
    TreeMap<Comparable<T>, List<V>> map = new TreeMap();

    public List<V> getInInterval(Comparable<T> key) {
        List<V> res = this.map.get(key);
        if (res != null) {
            return res;
        }
        SortedMap<Comparable<T>, List<V>> submap = this.map.headMap(key);
        if (submap.size() == 0) {
            return Collections.emptyList();
        }
        return (List)submap.get(submap.lastKey());
    }

    public void putInterval(Comparable<T> fromKey, Comparable<T> toKey, V value) {
        SortedMap<Comparable<T>, List<V>> submap = this.map.subMap(fromKey, toKey);
        if (submap.size() == 0 || !submap.firstKey().equals(fromKey)) {
            SortedMap<Comparable<T>, List<V>> head = this.map.headMap(fromKey);
            ArrayList firstList = head.size() == 0 ? new ArrayList() : new ArrayList((Collection)head.get(head.lastKey()));
            this.map.put(fromKey, firstList);
            submap = this.map.subMap(fromKey, toKey);
        }
        if (!this.map.containsKey(toKey)) {
            ArrayList lastList = new ArrayList((Collection)submap.get(submap.lastKey()));
            this.map.put(toKey, lastList);
        }
        for (Map.Entry<Comparable<T>, List<V>> element : submap.entrySet()) {
            element.getValue().add(value);
        }
    }

    public boolean removeInterval(Comparable<T> fromKey, Comparable<T> toKey, V value) {
        SortedMap<Comparable<T>, List<V>> submap = this.map.subMap(fromKey, toKey);
        if (submap.size() == 0) {
            throw new RuntimeException("Interval not found! " + fromKey + " - " + toKey);
        }
        if (!submap.firstKey().equals(fromKey)) {
            throw new RuntimeException("Interval should start with " + toKey);
        }
        ArrayList<Comparable<T>> removedKeys = new ArrayList<Comparable<T>>();
        for (Map.Entry<Comparable<T>, List<V>> e : submap.entrySet()) {
            boolean removed = e.getValue().remove(value);
            if (!removed) {
                throw new RuntimeException("Value not found: " + value + " at the Key: " + e.getKey());
            }
            if (e.getValue().size() != 0) continue;
            removedKeys.add(e.getKey());
        }
        return true;
    }

    public TreeMap<Comparable<T>, List<V>> treeMap() {
        return this.map;
    }
}

