/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

public class MultiIndexIterator {
    int[] dims;
    int[] values;
    boolean firstTime = true;

    public MultiIndexIterator(int[] dims) {
        this.dims = dims;
        this.values = new int[dims.length];
        this.firstTime = dims.length > 0;
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] != 0) continue;
            this.firstTime = false;
        }
    }

    public boolean hasNext() {
        if (this.firstTime) {
            return true;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            if (this.values[i] >= this.dims[i] - 1) continue;
            return true;
        }
        return false;
    }

    public int[] nextDim() {
        if (this.firstTime) {
            this.firstTime = false;
            return this.values;
        }
        for (int i = 0; i < this.values.length; ++i) {
            int n = i;
            this.values[n] = this.values[n] + 1;
            if (this.values[n] < this.dims[i]) break;
            this.values[i] = 0;
        }
        return this.values;
    }
}

