/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import org.apache.commons.lang.builder.EqualsBuilder;

public class RangeWithBounds {
    private Number min;
    private Number max;
    private BoundType leftBoundType;
    private BoundType rightBoundType;

    public RangeWithBounds(Number min, Number max) {
        this(min, max, BoundType.INCLUDING, BoundType.INCLUDING);
    }

    public RangeWithBounds(Number min, Number max, BoundType leftBoundType, BoundType rightBoundType) {
        this.min = min;
        this.max = max;
        this.leftBoundType = leftBoundType;
        this.rightBoundType = rightBoundType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RangeWithBounds)) {
            return false;
        }
        RangeWithBounds other = (RangeWithBounds)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.max, (Object)other.getMax());
        builder.append((Object)this.min, (Object)other.getMin());
        builder.append((Object)this.leftBoundType, (Object)other.getLeftBoundType());
        builder.append((Object)this.rightBoundType, (Object)other.getRightBoundType());
        return builder.isEquals();
    }

    public BoundType getLeftBoundType() {
        return this.leftBoundType;
    }

    public void setLeftBoundType(BoundType leftBoundType) {
        this.leftBoundType = leftBoundType;
    }

    public BoundType getRightBoundType() {
        return this.rightBoundType;
    }

    public void setRightBoundType(BoundType rightBoundType) {
        this.rightBoundType = rightBoundType;
    }

    public Number getMax() {
        return this.max;
    }

    public Number getMin() {
        return this.min;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        result = 31 * result + this.leftBoundType.hashCode();
        result = 31 * result + this.rightBoundType.hashCode();
        return result;
    }

    public void setMax(Number max) {
        this.max = max;
    }

    public void setMin(Number min) {
        this.min = min;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.leftBoundType == BoundType.INCLUDING) {
            builder.append('[');
        } else {
            builder.append('(');
        }
        builder.append(this.min + ".." + this.max);
        if (this.rightBoundType == BoundType.INCLUDING) {
            builder.append(']');
        } else {
            builder.append(')');
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoundType {
        INCLUDING,
        EXCLUDING;

    }
}

