/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipList<K, V>
implements Map<K, V> {
    Comparator<K> keyComparator;
    double nodeRatio;
    int maxIndexLevel;
    int indexLevel = 0;
    ISkipListNode<K, V> header;
    int size = 0;
    Random random = new Random(0L);

    public SkipList() {
        this(null, 0.3, 10);
    }

    public SkipList(Comparator<K> keyComparator, double nodeRatio, int maxLevel) {
        this.keyComparator = keyComparator;
        this.nodeRatio = nodeRatio;
        this.maxIndexLevel = maxLevel;
        this.clear();
    }

    @Override
    public void clear() {
        this.header = this.makeSkipListNode(null, null, this.maxIndexLevel + 1);
        this.size = 0;
        this.indexLevel = 0;
    }

    final int compare(K myKey, K key) {
        if (this.keyComparator == null) {
            return 0;
        }
        return myKey == null ? -1 : this.keyComparator.compare(myKey, key);
    }

    @Override
    public boolean containsKey(Object key) {
        Object k = key;
        ISkipListNode<Object, V> inode = this.findNodeGE(k);
        return this.hasKey(inode, k);
    }

    @Override
    public boolean containsValue(Object value) {
        for (ISkipListNode<K, V> node = this.header.next(0); node != null; node = node.next(0)) {
            if (!value.equals(node.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    ISkipListNode<K, V> findNodeGE(K searchKey) {
        ISkipListNode<K, V> x = this.header;
        for (int i = this.indexLevel; i >= 0; --i) {
            while (x.next(i) != null && this.compare(x.next(i).getKey(), searchKey) < 0) {
                x = x.next(i);
            }
        }
        x = x.next(0);
        return x;
    }

    @Override
    public V get(Object key) {
        Object k = key;
        ISkipListNode<Object, V> inode = this.findNodeGE(k);
        if (this.hasKey(inode, k)) {
            return inode.getValue();
        }
        return null;
    }

    final boolean hasKey(ISkipListNode<K, V> inode, K key) {
        return inode == null || inode == this.header ? false : inode.getKey().equals(key);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    protected ISkipListNode<K, V> makeSkipListNode(K key, V value, int level) {
        return new SkipListNode<K, V>(key, value, level + 1);
    }

    @Override
    public V put(K searchKey, V newValue) {
        int i;
        ISkipListNode[] path = new ISkipListNode[this.maxIndexLevel + 1];
        ISkipListNode x = this.header;
        for (int i2 = this.indexLevel; i2 >= 0; --i2) {
            while (x.next(i2) != null && this.compare(x.next(i2).getKey(), searchKey) < 0) {
                x = x.next(i2);
            }
            path[i2] = x;
        }
        if (this.hasKey(x = x.next(0), searchKey)) {
            Object oldValue = x.getValue();
            x.setValue(newValue);
            return oldValue;
        }
        ++this.size;
        int lvl = this.randomLevel();
        if (lvl > this.indexLevel) {
            for (i = this.indexLevel + 1; i <= lvl; ++i) {
                path[i] = this.header;
            }
            this.indexLevel = lvl;
        }
        x = this.makeSkipListNode(searchKey, newValue, lvl);
        for (i = 0; i <= lvl; ++i) {
            x.setNext(path[i].next(i), i);
            path[i].setNext(x, i);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    private int randomLevel() {
        int i;
        int max = Math.min(this.maxIndexLevel, this.indexLevel + 1);
        for (i = 0; i < max; ++i) {
            double d = this.random.nextDouble();
            if (!(d > this.nodeRatio)) continue;
            return i;
        }
        return i;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SkipListNode<K, V>
    implements ISkipListNode<K, V> {
        ISkipListNode<K, V>[] nodes;
        K key;
        V value;

        SkipListNode(K key, V value, int level) {
            this.key = key;
            this.value = value;
            this.nodes = new ISkipListNode[level];
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public int getLevel() {
            return this.nodes.length;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public ISkipListNode<K, V> next(int level) {
            return this.nodes[level];
        }

        @Override
        public void setNext(ISkipListNode<K, V> node, int level) {
            this.nodes[level] = node;
        }

        @Override
        public V setValue(V value) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ISkipListNode<K, V>
    extends Map.Entry<K, V> {
        public int getLevel();

        public ISkipListNode<K, V> next(int var1);

        public void setNext(ISkipListNode<K, V> var1, int var2);
    }
}

