/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.openl.util.RuntimeExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTool {
    static final char[] STRING_TO_XML_REPLACE_FROM = new char[]{'>', '<', '&', '\'', '\"'};
    static final String[] STRING_TO_XML_REPLACE_TO = new String[]{"&gt;", "&lt;", "&amp;", "&#39;", "&quot;"};
    static final char[] STRING_TO_XML_BODY_REPLACE_FROM = new char[]{'>', '<', '&', '\'', '\"', ' '};
    static final String[] STRING_TO_XML_BODY_REPLACE_TO = new String[]{"&gt;", "&lt;", "&amp;", "&#39;", "&quot;", "&nbsp;"};
    public static final int EMPTY = 1;
    public static final int COPY = 2;
    public static final int ERROR = 3;
    public static Selector VALID_JAVA_IDENTIFICATOR = new Selector(){

        public boolean select(char c, int idx) {
            if (idx > 0) {
                return Character.isJavaIdentifierPart(c);
            }
            return Character.isJavaIdentifierStart(c);
        }
    };
    public static Convertor IGNORE = new Convertor(){

        public void convert(char c, int idx, StringBuffer out) {
        }
    };
    public static Convertor UPPER = new Convertor(){

        public void convert(char c, int idx, StringBuffer out) {
            out.append(Character.toUpperCase(c));
        }
    };
    public static Convertor LOWER = new Convertor(){

        public void convert(char c, int idx, StringBuffer out) {
            out.append(Character.toLowerCase(c));
        }
    };
    public static final MacroKeyHandler MKH_DONOTHING = new MacroKeyHandler(){

        public void handleKey(String key, MacroSubst ms, StringBuffer out) {
        }
    };
    public static final MacroKeyHandler MKH_LEAVE = new MacroKeyHandler(){

        public void handleKey(String key, MacroSubst ms, StringBuffer out) {
            out.append(ms._macroDelim).append(key).append(ms._macroDelim);
        }
    };
    public static final MacroKeyHandler MKH_ERROR = new MacroKeyHandler(){

        public void handleKey(String key, MacroSubst ms, StringBuffer out) {
            throw new RuntimeException("Key " + key + " not found");
        }
    };

    public static StringBuffer append(StringBuffer buf, char c, int n) {
        for (int i = 0; i < n; ++i) {
            buf.append(c);
        }
        return buf;
    }

    public static String byteArrayToHexString(byte[] src, int off, int len) {
        StringBuffer out = new StringBuffer();
        for (int i = off; i < off + len; ++i) {
            String s = Integer.toHexString(src[i] & 0xFF);
            if (s.length() % 2 != 0) {
                out.append("0");
            }
            out.append(s);
        }
        return out.toString();
    }

    public static String decapitalizeName(String capitalized, String separator) {
        return StringTool.decapitalizeName(capitalized, separator, new StringBuffer()).toString();
    }

    public static StringBuffer decapitalizeName(String capitalized, String separator, StringBuffer buf) {
        if (capitalized == null) {
            return buf;
        }
        if (separator == null) {
            separator = "";
        }
        int start = 0;
        boolean prevUP = false;
        char[] src = capitalized.toCharArray();
        for (int i = 0; i < src.length; ++i) {
            char c = src[i];
            if (Character.isUpperCase(c)) {
                if (!prevUP) {
                    prevUP = true;
                    if (i > start) {
                        buf.append(src, start, i - start);
                        start = i;
                        buf.append(separator);
                    }
                }
                src[i] = Character.toLowerCase(c);
                continue;
            }
            if (!prevUP) continue;
            prevUP = false;
            int len = i - start;
            if (len <= 1) continue;
            buf.append(src, start, len - 1);
            start = i - 1;
            buf.append(separator);
        }
        buf.append(src, start, src.length - start);
        return buf;
    }

    public static String encodeHTMLBody(String content) {
        StringBuffer buf = new StringBuffer(100);
        StringTool.encodeHTMLBody(content, buf);
        return buf.toString();
    }

    public static StringBuffer encodeHTMLBody(String content, StringBuffer buf) {
        StringTool.prepareXMLAttributeValue(content, buf);
        return buf;
    }

    public static String encodeURL(String url) {
        String encodedUrl = null;
        try {
            encodedUrl = URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodedUrl;
    }

    public static String decodeURL(String url) {
        String decodedUrl = null;
        try {
            decodedUrl = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return decodedUrl;
    }

    public static String filter(String src, Selector sel, Convertor conv) {
        return StringTool.filter(src, sel, conv, new StringBuffer()).toString();
    }

    public static StringBuffer filter(String src, Selector sel, Convertor conv, StringBuffer buf) {
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (!sel.select(c, i)) {
                conv.convert(c, i, buf);
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    public static String firstToken(String src, String delim) {
        String[] tokens = StringTool.tokenize(src, delim);
        return tokens.length > 0 ? tokens[0] : "";
    }

    public static int indexOfClosingBracket(String src, char openingBracket, char closingBracket, int fromIndex) {
        int len = src.length();
        int cnt = 1;
        for (int i = fromIndex; i < len; ++i) {
            char c = src.charAt(i);
            if (c == closingBracket) {
                if (--cnt != 0) continue;
                return i;
            }
            if (c != openingBracket) continue;
            ++cnt;
        }
        return -1;
    }

    public static boolean isSpace(char c) {
        return c <= ' ' || Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    public static String keepChars(String src, String toKeep) {
        StringBuffer buf = new StringBuffer(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (toKeep.indexOf(c) < 0) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String lastToken(String src, String delim) {
        String[] tokens = StringTool.tokenize(src, delim);
        return tokens.length > 0 ? tokens[tokens.length - 1] : "";
    }

    public static String macroSubst(String src, Map<String, String> macros, char macroDelim, MacroKeyHandler mkh) {
        return StringTool.macroSubst(src, macros, macroDelim, mkh, new StringBuffer()).toString();
    }

    public static StringBuffer macroSubst(String src, Map<String, String> macros, char macroDelim, MacroKeyHandler mkh, StringBuffer buf) {
        MacroSubst ms = new MacroSubst(macros, macroDelim, mkh);
        return ms.transform(src, buf);
    }

    public static String makeJavaIdentifier(String src) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (i == 0) {
                buf.append(Character.isJavaIdentifierStart(c) ? c : (char)'_');
                continue;
            }
            buf.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return buf.toString();
    }

    public static String[] openBrackets(String src, char openingBracket, char closingBracket, String ignore) {
        int len = src.length();
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == openingBracket) {
                int closed = StringTool.indexOfClosingBracket(src, openingBracket, closingBracket, i + 1);
                if (closed == -1) {
                    throw new RuntimeException("Expected: " + closingBracket);
                }
                v.add(src.substring(i + 1, closed));
                i = closed;
                continue;
            }
            if (ignore.indexOf(c) != -1) continue;
            throw new RuntimeException("UnExpected: " + c);
        }
        return v.toArray(new String[v.size()]);
    }

    public static StringBuffer prepareXMLAttributeValue(String attrValue, StringBuffer buf) {
        return StringTool.replaceCharsWithStrings(buf, attrValue, STRING_TO_XML_REPLACE_FROM, STRING_TO_XML_REPLACE_TO);
    }

    public static String prepareXMLBodyValue(String content) {
        StringBuffer buf = new StringBuffer(100);
        StringTool.prepareXMLBodyValue(content, buf);
        return buf.toString();
    }

    public static StringBuffer prepareXMLBodyValue(String attrValue, StringBuffer buf) {
        return StringTool.replaceCharsWithStrings(buf, attrValue, STRING_TO_XML_BODY_REPLACE_FROM, STRING_TO_XML_BODY_REPLACE_TO);
    }

    public static String propetyToLabel(String propertyName) {
        return StringTool.propetyToLabel(propertyName, new StringBuffer()).toString();
    }

    public static StringBuffer propetyToLabel(String propertyName, StringBuffer sb) {
        if (propertyName == null || propertyName.length() == 0) {
            return sb;
        }
        int len = propertyName.length();
        int i = 0;
        char lastChar = ' ';
        while (i < len) {
            char c = propertyName.charAt(i);
            if (c == '_') {
                if (sb.length() > 0) {
                    lastChar = ' ';
                    sb.append(lastChar);
                }
                while (++i < len && propertyName.charAt(i) == '_') {
                }
                continue;
            }
            if (Character.isUpperCase(c) && !Character.isUpperCase(lastChar) && lastChar != ' ') {
                lastChar = ' ';
                sb.append(lastChar);
            }
            if (lastChar == ' ') {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            lastChar = c;
            ++i;
        }
        return sb;
    }

    public static String removeChars(String src, String toRemove) {
        StringBuffer buf = new StringBuffer(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (toRemove.indexOf(c) >= 0) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String replace(String src, String toFind, String toReplace) {
        return StringTool.replace(src, toFind, toReplace, true, false, new StringBuffer()).toString();
    }

    public static String replace(String src, String toFind, String toReplace, boolean all, boolean ignoreCase) {
        return StringTool.replace(src, toFind, toReplace, all, ignoreCase, new StringBuffer()).toString();
    }

    public static StringBuffer replace(String src, String toFind, String toReplace, boolean all, boolean ignoreCase, StringBuffer out) {
        int idx;
        int find_len = toFind.length();
        int src_len = src.length();
        int replace_len = toReplace.length();
        int start = 0;
        String test_src = src;
        String test_tofind = toFind;
        if (ignoreCase) {
            test_src = src.toLowerCase();
            test_tofind = toFind.toLowerCase();
        }
        while (start + find_len <= src_len && (idx = test_src.indexOf(test_tofind, start)) >= 0) {
            if (start != idx) {
                out.append(src.substring(start, idx));
            }
            if (replace_len > 0) {
                out.append(toReplace);
            }
            start = idx + find_len;
            if (all) continue;
            break;
        }
        if (start < src_len) {
            out.append(src.substring(start));
        }
        return out;
    }

    public static final String replaceCharsWithStrings(String sourceStr, char[] replaceFrom, String[] replaceTo) {
        if (sourceStr == null || sourceStr.equals("")) {
            return "";
        }
        if (replaceFrom.length == 0) {
            return sourceStr;
        }
        int length = sourceStr.length();
        StringBuffer result = new StringBuffer(length + 20);
        StringTool.replaceCharsWithStrings(result, sourceStr, replaceFrom, replaceTo);
        return result.toString();
    }

    public static final String replaceCharsWithStrings(String sourceStr, CharToStringConverter converter) {
        if (sourceStr == null || sourceStr.equals("")) {
            return "";
        }
        if (converter == null) {
            return sourceStr;
        }
        int length = sourceStr.length();
        StringBuffer result = new StringBuffer(length + 20);
        StringTool.replaceCharsWithStrings(result, sourceStr, converter);
        return result.toString();
    }

    public static final StringBuffer replaceCharsWithStrings(StringBuffer result, String sourceStr, char[] replaceFrom, String[] replaceTo) {
        if (replaceFrom.length != replaceTo.length) {
            throw new RuntimeException("Program Error: replaceFrom.length != replaceTo.length");
        }
        if (sourceStr == null || sourceStr.equals("")) {
            return result;
        }
        if (replaceFrom.length == 0) {
            result.append(sourceStr);
            return result;
        }
        int length = sourceStr.length();
        for (int i = 0; i < length; ++i) {
            char nextChar = sourceStr.charAt(i);
            boolean isFound = false;
            for (int j = 0; j < replaceFrom.length; ++j) {
                char replaceChar = replaceFrom[j];
                if (nextChar != replaceChar) continue;
                result.append(replaceTo[j]);
                isFound = true;
                break;
            }
            if (isFound) continue;
            result.append(nextChar);
        }
        return result;
    }

    public static final void replaceCharsWithStrings(StringBuffer result, String sourceStr, CharToStringConverter converter) {
        if (sourceStr == null || sourceStr.equals("")) {
            return;
        }
        if (converter == null) {
            result.append(sourceStr);
            return;
        }
        int length = sourceStr.length();
        for (int i = 0; i < length; ++i) {
            char nextChar = sourceStr.charAt(i);
            String newChar = converter.convertOrNull(nextChar);
            if (newChar == null) {
                result.append(nextChar);
                continue;
            }
            result.append(newChar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] splitLines(Reader reader) {
        String[] stringArray;
        BufferedReader br = new BufferedReader(reader);
        ArrayList<String> v = new ArrayList<String>();
        try {
            String s;
            while ((s = br.readLine()) != null) {
                v.add(s);
            }
            stringArray = v.toArray(new String[v.size()]);
        }
        catch (Throwable throwable) {
            try {
                br.close();
                throw throwable;
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrap(e);
            }
        }
        br.close();
        return stringArray;
    }

    public static String[] splitLines(String src) {
        return StringTool.splitLines(new StringReader(src));
    }

    public static String[] tokenize(String src, String delim) {
        StringTokenizer st = new StringTokenizer(src, delim);
        int cnt = st.countTokens();
        String[] res = new String[cnt];
        for (int i = 0; i < res.length; ++i) {
            res[i] = st.nextToken();
        }
        return res;
    }

    public static String toValidJavaIdentificator(String src) {
        return StringTool.filter(src, VALID_JAVA_IDENTIFICATOR, IGNORE);
    }

    public static String trimGood(String src) {
        return StringTool.trimGood(src, new StringBuffer()).toString();
    }

    public static StringBuffer trimGood(String src, StringBuffer out) {
        int st;
        int len;
        int count = len = src.length();
        for (st = 0; st < len && StringTool.isSpace(src.charAt(st)); ++st) {
        }
        while (st < len && StringTool.isSpace(src.charAt(len - 1))) {
            --len;
        }
        if (st > 0 || len < count) {
            if (st != len) {
                out.append(src.substring(st, len));
            }
        } else {
            out.append(src);
        }
        return out;
    }

    public static String untab(String src, int tabSize) {
        StringBuffer buf = new StringBuffer(src.length() + 10);
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c != '\t') {
                buf.append(c);
                continue;
            }
            buf.append(' ');
            int extra = buf.length() % tabSize;
            if (extra == 0) continue;
            StringTool.append(buf, ' ', tabSize - extra);
        }
        return buf.toString();
    }

    public static String xmlProperty(String key, String value) {
        return StringTool.xmlProperty(key, value, new StringBuffer()).toString();
    }

    public static StringBuffer xmlProperty(String key, String value, StringBuffer buf) {
        buf.append(key).append("='");
        StringTool.prepareXMLAttributeValue(value, buf);
        buf.append('\'');
        return buf;
    }

    public static String getFileNameOfJavaClass(Class<?> c) {
        return c.getName().replace('.', '/') + ".java";
    }

    public static String[] splitAndEscape(String src, String symbolToSplit, String symbolToEscape) {
        String[] result = null;
        String[] tokens = src.split(symbolToSplit);
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        if (symbolToEscape != null) {
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].endsWith(symbolToEscape)) {
                    tokens[i] = tokens[i].trim();
                    String tokenWithoutEscaper = tokens[i].substring(0, tokens[i].length() - 1);
                    buf.append(tokenWithoutEscaper).append(symbolToSplit);
                    continue;
                }
                if (buf.length() == 0) {
                    tokens[i] = tokens[i].trim();
                    resultList.add(tokens[i]);
                    continue;
                }
                buf.append(tokens[i]);
                resultList.add(buf.toString());
                buf.delete(0, buf.length());
            }
            result = resultList.toArray(new String[0]);
        } else {
            result = tokens;
        }
        return result;
    }

    public static String insertStringToString(String baseStr, String strToInsertBefore, String insertion) {
        String src = baseStr;
        String[] tokens = src.split(strToInsertBefore);
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            strBuf.append(token);
            if (i == tokens.length - 1) continue;
            strBuf.append(insertion);
            strBuf.append(strToInsertBefore);
        }
        return strBuf.toString();
    }

    public static String listToStringThroughCommas(List<String> values) {
        String result = null;
        if (values != null && !values.isEmpty()) {
            StringBuffer strBuf = new StringBuffer();
            int paramNum = values.size();
            for (String value : values) {
                strBuf.append(value);
                if (--paramNum <= 0) continue;
                strBuf.append(", ");
            }
            result = strBuf.toString();
        }
        return result;
    }

    public static String getSetterName(String fieldName) {
        return String.format("set%s%s", fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1));
    }

    public static String getGetterName(String fieldName) {
        return String.format("get%s%s", fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1));
    }

    public static class TextTransformer {
        public static final char EOF = '\uffff';
        protected char prev = (char)65535;
        protected char cur = (char)65535;
        protected char next = (char)65535;
        protected StringBuffer out = null;
        private StringBuffer tmp = null;
        protected int len = -1;
        protected int status = 0;
        protected int idx = 0;

        public String flushTmp() {
            String s = this.tmp().toString();
            this.tmp.setLength(0);
            return s;
        }

        public void process() {
            this.out.append(this.cur);
        }

        public final StringBuffer tmp() {
            if (this.tmp == null) {
                this.tmp = new StringBuffer();
            }
            return this.tmp;
        }

        public String transform(String src) {
            return this.transform(src, new StringBuffer()).toString();
        }

        public StringBuffer transform(String src, StringBuffer buf) {
            this.out = buf;
            this.len = src.length();
            if (this.len > 0) {
                this.next = src.charAt(0);
            }
            this.idx = 0;
            while (this.idx < this.len) {
                this.prev = this.cur;
                this.cur = this.next;
                this.next = (char)(this.idx + 1 < this.len ? (int)src.charAt(this.idx + 1) : 65535);
                this.process();
                ++this.idx;
            }
            this.veryEnd();
            return this.out;
        }

        public void veryEnd() {
        }
    }

    public static interface Selector {
        public boolean select(char var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MacroSubst
    extends TextTransformer {
        public char _macroDelim;
        public Map<String, String> _macros;
        MacroKeyHandler _mkh;

        public MacroSubst(Map<String, String> macros, char macroDelim, MacroKeyHandler mkh) {
            this._macros = macros;
            this._macroDelim = macroDelim;
            this._mkh = mkh;
        }

        @Override
        public void process() {
            if (this.cur == this._macroDelim) {
                if (this.status == 0) {
                    this.status = 1;
                } else {
                    this.status = 0;
                    String key = this.flushTmp();
                    String res = this._macros.get(key);
                    if (res == null) {
                        this._mkh.handleKey(key, this, this.out);
                    } else {
                        this.out.append(res);
                    }
                }
            } else if (this.status == 0) {
                this.out.append(this.cur);
            } else {
                this.tmp().append(this.cur);
            }
        }
    }

    public static interface MacroKeyHandler {
        public void handleKey(String var1, MacroSubst var2, StringBuffer var3);
    }

    public static interface Convertor {
        public void convert(char var1, int var2, StringBuffer var3);
    }

    public static abstract class CharToStringConverter {
        public String convert(char ch) {
            String res = this.convertOrNull(ch);
            if (res == null) {
                return String.valueOf(ch);
            }
            return res;
        }

        public abstract String convertOrNull(char var1);
    }
}

