/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTransformer {
    static final int NORMAL = 0;
    static final int BSLASH = 1;
    static final int DOLLAR = 2;
    static final int IN_NAME = 3;
    boolean processBackslash = false;
    boolean reportNotFoundVarException = true;

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("abc", "abc value");
        System.out.println(new StringTransformer().transform("abcd\\s${abc}", map, new StringBuilder()));
    }

    public StringTransformer() {
    }

    public StringTransformer(boolean processBackslash, boolean reportNotFoundVarException) {
        this.processBackslash = processBackslash;
        this.reportNotFoundVarException = reportNotFoundVarException;
    }

    public String transform(String src, IVarHolder vars) {
        return this.transform(src, vars, new StringBuilder(100)).toString();
    }

    public StringBuilder transform(String src, IVarHolder vars, StringBuilder buf) {
        int len = src.length();
        int state = 0;
        StringBuilder nameBuilder = null;
        block6: for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\\' && this.processBackslash) {
                        state = 1;
                        continue block6;
                    }
                    if (c == '$') {
                        state = 2;
                        continue block6;
                    }
                    buf.append(c);
                    continue block6;
                }
                case 1: {
                    state = 0;
                    buf.append(c);
                    continue block6;
                }
                case 2: {
                    if (c == '{') {
                        state = 3;
                        nameBuilder = new StringBuilder();
                        continue block6;
                    }
                    state = 0;
                    buf.append('$').append(c);
                    continue block6;
                }
                case 3: {
                    if (c == '}') {
                        String name = nameBuilder.toString();
                        String subst = vars.find(name);
                        if (subst == null) {
                            if (this.reportNotFoundVarException) {
                                throw new RuntimeException("Can not find var:" + name);
                            }
                            buf.append("${").append(name).append('}');
                        } else {
                            buf.append(subst);
                        }
                        state = 0;
                        continue block6;
                    }
                    nameBuilder.append(c);
                }
            }
        }
        if (state == 2) {
            buf.append('$');
        } else if (state != 0) {
            throw new RuntimeException("Can not transform the string:" + src);
        }
        return buf;
    }

    public StringBuilder transform(String src, Map<String, String> map, StringBuilder buf) {
        return this.transform(src, new MapVarHolder(map), buf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapVarHolder
    implements IVarHolder {
        Map<String, String> map;

        public MapVarHolder(Map<String, String> map) {
            this.map = map;
        }

        @Override
        public String find(String name) {
            return this.map.get(name);
        }
    }

    public static interface IVarHolder {
        public String find(String var1);
    }
}

