/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.benchmark;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.openl.util.IdMap;
import org.openl.util.IdObject;
import org.openl.util.benchmark.Benchmark;
import org.openl.util.benchmark.BenchmarkInfo;
import org.openl.util.benchmark.BenchmarkUnit;

public class BenchmarkJavaBasics {
    static ThreadLocal<Object> tracer = new ThreadLocal();

    public static boolean isTracerOn() {
        return tracer.get() != null;
    }

    public static void main(String[] args) throws Exception {
        BenchmarkUnit[] bu = new BenchmarkUnit[]{new Empty(), new Call(), new Invoke(), new MapGet(), new MapInternGet(), new IDMapGet(), new ThreadG(), new TreeMapGet(), new TreeMapGetFirstKey(), new BSearch()};
        List<BenchmarkInfo> res = new Benchmark(bu).measureAllInList(1000);
        for (BenchmarkInfo bi : res) {
            System.out.println(bi);
        }
    }

    public int add(int x, int y) {
        return x + y;
    }

    static class TreeMapGetFirstKey
    extends BenchmarkUnit {
        TreeMap<Integer, String> map;
        Integer key = new Integer(51);

        TreeMapGetFirstKey() throws Exception {
            this.map = new TreeMap();
            for (int i = 0; i < 100; ++i) {
                this.map.put(new Integer(i * 2), "Xyz" + i);
            }
        }

        protected void run() throws Exception {
            Iterator<String> it = this.map.tailMap(this.key).values().iterator();
            if (it.hasNext()) {
                it.next();
            }
        }
    }

    static class TreeMapGet
    extends BenchmarkUnit {
        TreeMap<Integer, String> map;
        Integer key = new Integer(50);

        TreeMapGet() throws Exception {
            this.map = new TreeMap();
            for (int i = 0; i < 100; ++i) {
                this.map.put(new Integer(i * 2), "Xyz" + i);
            }
        }

        protected void run() throws Exception {
            this.map.get(this.key);
        }
    }

    static class ThreadG
    extends BenchmarkUnit {
        ThreadG() {
        }

        protected void run() throws Exception {
            BenchmarkJavaBasics.isTracerOn();
        }
    }

    static class MapInternGet
    extends BenchmarkUnit {
        HashMap<String, String> map;
        String key = "Xyz37".intern();

        MapInternGet() throws Exception {
            this.map = new HashMap();
            for (int i = 0; i < 100; ++i) {
                this.map.put(("Xyz" + i).intern(), "Xyz" + i);
            }
        }

        protected void run() throws Exception {
            this.map.get(this.key);
        }
    }

    static class MapGet
    extends BenchmarkUnit {
        HashMap<String, String> map = new HashMap();
        String key = "Xyz37";

        MapGet() throws Exception {
            for (int i = 0; i < 100; ++i) {
                this.map.put("Xyz" + i, "Xyz" + i);
            }
        }

        protected void run() throws Exception {
            this.map.get(this.key);
        }
    }

    static class Invoke
    extends BenchmarkUnit {
        Method m = BenchmarkJavaBasics.class.getMethod("add", Integer.TYPE, Integer.TYPE);
        Object[] params = new Object[]{new Integer(10), new Integer(15)};
        Object bjb = new BenchmarkJavaBasics();

        Invoke() throws Exception {
        }

        protected void run() throws Exception {
            this.m.invoke(this.bjb, this.params);
        }
    }

    static class IDMapGet
    extends BenchmarkUnit {
        IdMap map;
        int key = "Xyz37".hashCode();

        IDMapGet() throws Exception {
            this.map = new IdMap(107);
            for (int i = 0; i < 100; ++i) {
                this.map.add(new IdObject(("Xyz" + i).hashCode()));
            }
        }

        protected void run() throws Exception {
            this.map.get(this.key);
        }
    }

    static class Empty
    extends BenchmarkUnit {
        Empty() {
        }

        protected void run() throws Exception {
        }
    }

    static class Call
    extends BenchmarkUnit {
        BenchmarkJavaBasics bjb = new BenchmarkJavaBasics();

        Call() throws Exception {
        }

        protected void run() throws Exception {
            this.bjb.add(10, 15);
        }
    }

    static class BSearch
    extends BenchmarkUnit {
        static int N = 100;
        int[] buf = new int[N];
        int key = 51;

        BSearch() throws Exception {
            for (int i = 0; i < N; ++i) {
                this.buf[i] = i * 4;
            }
        }

        protected void run() throws Exception {
            Arrays.binarySearch(this.buf, this.key);
        }
    }
}

