/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.formatters;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.openl.util.Log;
import org.openl.util.formatters.IFormatter;

public class NumberTextFormatter
implements IFormatter {
    private DecimalFormat format;

    public NumberTextFormatter(DecimalFormat fmt) {
        this.format = fmt;
    }

    public NumberTextFormatter(String fmt) {
        this.format = new DecimalFormat(fmt);
    }

    public String format(Object obj) {
        return this.format.format(obj);
    }

    public Object parse(String value) {
        try {
            return this.format.parse(value);
        }
        catch (ParseException e) {
            Log.warn("Could not parse number: " + value);
            try {
                return DateFormat.getDateInstance().parse(value);
            }
            catch (ParseException pe) {
                return value;
            }
        }
    }
}

