/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.generation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openl.util.generation.JavaClassGeneratorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBeanJavaGenerator {
    private String datatypeName;
    private Class<?> datatypeClass;
    private Map<String, Class<?>> datatypeDeclaredFields;
    private Map<String, Class<?>> datatypeAllFields;

    public SimpleBeanJavaGenerator(Class<?> datatypeClass, Map<String, Class<?>> declaredFields, Map<String, Class<?>> allFields) {
        this.datatypeName = datatypeClass.getName();
        this.datatypeClass = datatypeClass;
        this.datatypeDeclaredFields = this.prepareFieldNames(declaredFields);
        this.datatypeAllFields = this.prepareFieldNames(allFields);
    }

    public LinkedHashMap<String, Class<?>> prepareFieldNames(Map<String, Class<?>> fields) {
        LinkedHashMap preparedFields = new LinkedHashMap();
        for (Map.Entry<String, Class<?>> field : fields.entrySet()) {
            String fieldName = field.getKey();
            String processedFieldName = String.format("%s%s", fieldName.substring(0, 1).toLowerCase(), fieldName.substring(1));
            preparedFields.put(processedFieldName, field.getValue());
        }
        return preparedFields;
    }

    public String generateJavaClass() {
        StringBuffer buf = new StringBuffer(10000);
        this.addComment(buf);
        this.addPackage(buf);
        this.addImports(buf);
        this.addClassDeclaration(buf, ClassUtils.getShortClassName((String)this.datatypeName), ClassUtils.getShortClassName(this.datatypeClass.getSuperclass()));
        this.addFieldsDeclaration(buf);
        this.addMethods(buf);
        buf.append("\n}");
        return buf.toString();
    }

    private void addMethods(StringBuffer buf) {
        this.addConstructors(buf);
        for (Method method : this.datatypeClass.getDeclaredMethods()) {
            if (method.getName().startsWith("get")) {
                this.addGetter(buf, method);
                continue;
            }
            if (method.getName().startsWith("set")) {
                this.addSetter(buf, method);
                continue;
            }
            if (method.getName().equals("equals")) {
                buf.append(JavaClassGeneratorHelper.getEqualsMethod(this.datatypeClass.getSimpleName(), this.datatypeAllFields));
                continue;
            }
            if (method.getName().startsWith("hashCode")) {
                buf.append(JavaClassGeneratorHelper.getHashCodeMethod(this.datatypeAllFields));
                continue;
            }
            if (!method.getName().equals("toString")) continue;
            buf.append(JavaClassGeneratorHelper.getToStringMethod(this.datatypeClass.getSimpleName(), this.datatypeAllFields));
        }
    }

    private void addConstructors(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getDefaultConstructor(this.datatypeClass.getSimpleName()));
        LinkedHashMap fieldsForConstructor = new LinkedHashMap();
        int numberOfParamsForSuperConstructor = 0;
        if (!this.datatypeClass.getSuperclass().equals(Object.class)) {
            numberOfParamsForSuperConstructor = this.datatypeAllFields.size() - this.datatypeDeclaredFields.size();
            Constructor<?> superConstructorWithFields = JavaClassGeneratorHelper.getBeanConstructorWithAllFields(this.datatypeClass.getSuperclass(), numberOfParamsForSuperConstructor);
            if (superConstructorWithFields != null) {
                int i = 0;
                for (Map.Entry<String, Class<?>> field : this.datatypeAllFields.entrySet()) {
                    if (field.getValue() != superConstructorWithFields.getParameterTypes()[i]) {
                        fieldsForConstructor.clear();
                        numberOfParamsForSuperConstructor = 0;
                    } else {
                        fieldsForConstructor.put(field.getKey(), field.getValue());
                        if (++i != numberOfParamsForSuperConstructor) continue;
                    }
                    break;
                }
            } else {
                numberOfParamsForSuperConstructor = 0;
            }
        }
        fieldsForConstructor.putAll(this.datatypeDeclaredFields);
        buf.append(JavaClassGeneratorHelper.getConstructorWithFields(this.datatypeClass.getSimpleName(), fieldsForConstructor, numberOfParamsForSuperConstructor));
    }

    private void addSetter(StringBuffer buf, Method method) {
        String fieldName = this.getFieldName(method.getName());
        buf.append(JavaClassGeneratorHelper.getPublicSetterMethod(this.filterTypeName(method.getParameterTypes()[0]), fieldName));
    }

    private void addGetter(StringBuffer buf, Method method) {
        String fieldName = this.getFieldName(method.getName());
        buf.append(JavaClassGeneratorHelper.getPublicGetterMethod(this.filterTypeName(method.getReturnType()), fieldName));
    }

    private String getFieldName(String methodName) {
        return String.format("%s%s", methodName.substring(3, 4).toLowerCase(), methodName.substring(4));
    }

    private void addFieldsDeclaration(StringBuffer buf) {
        for (Method method : this.datatypeClass.getDeclaredMethods()) {
            if (!method.getName().startsWith("get")) continue;
            buf.append(JavaClassGeneratorHelper.getProtectedFieldDeclaration(this.filterTypeName(method.getReturnType()), this.getFieldName(method.getName())));
        }
        buf.append("\n");
    }

    private void addClassDeclaration(StringBuffer buf, String className, String superClass) {
        buf.append(JavaClassGeneratorHelper.getSimplePublicClassDeclaration(className));
        if (superClass != null && !"Object".equals(superClass)) {
            buf.append(" extends ");
            buf.append(superClass);
        }
        buf.append(JavaClassGeneratorHelper.getOpenBracket());
    }

    private void addImports(StringBuffer buf) {
        for (String importStr : this.gatherImports()) {
            this.addImport(buf, importStr);
        }
    }

    private void addImport(StringBuffer buf, String importStr) {
        buf.append(JavaClassGeneratorHelper.getImportText(importStr));
    }

    private Set<String> gatherImports() {
        HashSet<String> importsSet = new HashSet<String>();
        for (Method method : this.datatypeClass.getDeclaredMethods()) {
            Class<?> methodReturnType;
            if (!(!method.getName().startsWith("get") || (methodReturnType = method.getReturnType()).isPrimitive() || methodReturnType.isArray() && methodReturnType.getComponentType().isPrimitive())) {
                importsSet.add(this.filterTypeNameForImport(methodReturnType));
            }
            if (method.getName().equals("equals")) {
                importsSet.add(this.filterTypeNameForImport(EqualsBuilder.class));
            }
            if (method.getName().startsWith("hashCode")) {
                importsSet.add(this.filterTypeNameForImport(HashCodeBuilder.class));
            }
            if (!method.getName().startsWith("toString")) continue;
            importsSet.add(this.filterTypeNameForImport(ArrayUtils.class));
        }
        for (Executable executable : this.datatypeClass.getDeclaredConstructors()) {
            for (Class<?> paramType : ((Constructor)executable).getParameterTypes()) {
                if (paramType.isPrimitive() || paramType.isArray() && paramType.getComponentType().isPrimitive()) continue;
                importsSet.add(this.filterTypeNameForImport(paramType));
            }
        }
        Class<?> superClass = this.datatypeClass.getSuperclass();
        if (superClass != Object.class) {
            importsSet.add(this.filterTypeNameForImport(superClass));
        }
        return importsSet;
    }

    private String filterTypeNameForImport(Class<?> type) {
        String typeName = this.filterTypeName(type);
        int index = typeName.indexOf("[");
        if (index > 0) {
            return typeName.substring(0, index);
        }
        return typeName;
    }

    private String filterTypeName(Class<?> type) {
        if (!(type.isPrimitive() || type.isArray() && type.getComponentType().isPrimitive())) {
            return String.format("%s.%s", ClassUtils.getPackageName(type), ClassUtils.getShortClassName(type));
        }
        return ClassUtils.getShortClassName(type);
    }

    private void addComment(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getCommentText("This class has been generated. Do not change it."));
    }

    private void addPackage(StringBuffer buf) {
        buf.append(JavaClassGeneratorHelper.getPackageText(ClassUtils.getPackageName(this.datatypeClass)));
    }
}

