/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.tree;

import java.util.Iterator;
import java.util.Stack;
import org.openl.util.AOpenIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterator<N>
extends AOpenIterator<N> {
    public static final int DEFAULT = 0;
    public static final int LEAVES_ONLY = 1;
    public static final int RIGHT_TO_LEFT = 2;
    public static final int NO_LEAVES = 4;
    public static final int BOTTOM_TOP = 8;
    N currentNode;
    TreeAdaptor<N> adaptor;
    Stack<NodeInfo<N>> path = new Stack();
    int mode = 0;
    Iterator<N> children = null;

    public TreeIterator(N treeRoot, TreeAdaptor<N> adaptor, int mode) {
        this.children = TreeIterator.single(treeRoot);
        this.adaptor = adaptor;
        this.mode = mode;
        this.findNextNode();
    }

    private void findNextNode() {
        if (this.children.hasNext()) {
            N nextChild = this.children.next();
            Iterator<N> grandChildren = this.adaptor.children(nextChild);
            if (TreeIterator.isEmpty(grandChildren)) {
                this.currentNode = nextChild;
                return;
            }
            if ((this.mode & 2) != 0) {
                grandChildren = TreeIterator.reverse(grandChildren);
            }
            this.path.push(new NodeInfo<N>(nextChild, this.children));
            this.children = grandChildren;
            if ((this.mode & 8) != 0) {
                this.findNextNode();
            } else {
                this.currentNode = nextChild;
            }
            return;
        }
        if (this.path.size() == 0) {
            this.currentNode = null;
            return;
        }
        NodeInfo<N> info = this.path.pop();
        this.children = info.children;
        if ((this.mode & 8) != 0) {
            this.currentNode = info.node;
            return;
        }
        this.findNextNode();
    }

    @Override
    public boolean hasNext() {
        return this.currentNode != null;
    }

    @Override
    public N next() {
        N result = this.currentNode;
        this.findNextNode();
        return result;
    }

    public TreeAdaptor<N> getAdaptor() {
        return this.adaptor;
    }

    public void setAdaptor(TreeAdaptor<N> adaptor) {
        this.adaptor = adaptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TreeAdaptor<N> {
        public Iterator<N> children(N var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NodeInfo<N> {
        N node;
        Iterator<N> children;

        NodeInfo(N node, Iterator<N> children) {
            this.node = node;
            this.children = children;
        }
    }
}

