/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.test;

import java.util.HashSet;
import java.util.Set;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.tree.DiffElement;
import org.openl.rules.diff.tree.DiffProperty;
import org.openl.rules.diff.tree.DiffStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffElementImpl
implements DiffElement {
    private Projection projection;
    private DiffStatus diffStatus;
    private Set<DiffProperty> diffProperties;
    private boolean hierarhyEqual;
    private boolean childrenEqual;
    private boolean selfEqual;

    public DiffElementImpl(Projection projection) {
        this.projection = projection;
        this.diffProperties = new HashSet<DiffProperty>();
    }

    @Override
    public DiffStatus getDiffStatus() {
        return this.diffStatus;
    }

    @Override
    public boolean isHierarhyEqual() {
        return this.hierarhyEqual;
    }

    @Override
    public boolean isChildrenEqual() {
        return this.childrenEqual;
    }

    @Override
    public boolean isSelfEqual() {
        return this.selfEqual;
    }

    @Override
    public Projection getProjection() {
        return this.projection;
    }

    @Override
    public DiffProperty[] getDiffProperties() {
        return this.diffProperties.toArray(new DiffProperty[this.diffProperties.size()]);
    }

    @Override
    public void addDiffProperty(DiffProperty property) {
        this.diffProperties.add(property);
    }

    public void setDiffProperties(Set<DiffProperty> properties) {
        this.diffProperties = properties;
    }

    public void asAdded() {
        this.hierarhyEqual = false;
        this.childrenEqual = false;
        this.selfEqual = false;
        this.diffStatus = DiffStatus.ADDED;
    }

    public void asRemoved() {
        this.hierarhyEqual = false;
        this.childrenEqual = false;
        this.selfEqual = false;
        this.diffStatus = DiffStatus.REMOVED;
    }

    public void asExists(boolean hierarhyEqual, boolean childrenEqual, boolean selfEqual) {
        this.hierarhyEqual = hierarhyEqual;
        this.childrenEqual = childrenEqual;
        this.selfEqual = selfEqual;
        if (childrenEqual && !hierarhyEqual) {
            throw new IllegalArgumentException("childrenEqual is 'true' while less strict hierarhyEqual is 'false'!");
        }
        this.diffStatus = childrenEqual && selfEqual ? DiffStatus.EQUALS : DiffStatus.DIFFERS;
    }

    public void asOriginal(boolean exists) {
        this.hierarhyEqual = exists;
        this.childrenEqual = exists;
        this.selfEqual = exists;
        this.diffStatus = exists ? DiffStatus.ORIGINAL : DiffStatus.ORIGINAL_ABSENT;
    }
}

