/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.diff.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.rules.diff.differs.ProjectionDiffer;
import org.openl.rules.diff.hierarchy.Projection;
import org.openl.rules.diff.hierarchy.ProjectionProperty;
import org.openl.rules.diff.test.DiffPropertyImpl;
import org.openl.rules.diff.test.MergeResult;
import org.openl.rules.diff.tree.DiffProperty;
import org.openl.rules.diff.tree.DiffStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionDifferImpl
implements ProjectionDiffer {
    private Set<DiffProperty> diffProperties = null;

    @Override
    public boolean compare(Projection original, Projection other) {
        ProjectionProperty p;
        this.diffProperties = new HashSet<DiffProperty>();
        Map<String, ProjectionProperty> map1 = ProjectionDifferImpl.buildMap(original);
        Map<String, ProjectionProperty> map2 = ProjectionDifferImpl.buildMap(other);
        MergeResult merged = MergeResult.mergeNames(map1.keySet(), map2.keySet());
        for (String propertyName : merged.getAdded()) {
            p = map2.get(propertyName);
            this.diffProperties.add(new DiffPropertyImpl(p, DiffStatus.ADDED));
        }
        for (String propertyName : merged.getRemoved()) {
            p = map2.get(propertyName);
            this.diffProperties.add(new DiffPropertyImpl(p, DiffStatus.REMOVED));
        }
        for (String propertyName : merged.getCommon()) {
            ProjectionProperty p2;
            ProjectionProperty p1 = map1.get(propertyName);
            if (!this.isEquals(p1, p2 = map2.get(propertyName))) {
                this.diffProperties.add(new DiffPropertyImpl(p2, DiffStatus.DIFFERS));
                continue;
            }
            this.diffProperties.add(new DiffPropertyImpl(p2, DiffStatus.EQUALS));
        }
        for (DiffProperty property : this.diffProperties) {
            DiffStatus status = property.getDiffStatus();
            if (status.equals((Object)DiffStatus.EQUALS)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEquals(ProjectionProperty p1, ProjectionProperty p2) {
        Class type2;
        Class type1 = p1.getType();
        if (type1 != (type2 = p2.getType())) {
            return false;
        }
        Object v1 = p1.getRawValue();
        Object v2 = p2.getRawValue();
        if (v1 == null) {
            return v1 == v2;
        }
        return v1.equals(v2);
    }

    static Map<String, ProjectionProperty> buildMap(Projection projection) {
        ProjectionProperty[] properties;
        HashMap<String, ProjectionProperty> map = new HashMap<String, ProjectionProperty>();
        for (ProjectionProperty property : properties = projection.getProperties()) {
            if (!property.isComparable()) continue;
            map.put(property.getName(), property);
        }
        return map;
    }

    @Override
    public Set<DiffProperty> getDiffProperties() {
        return this.diffProperties;
    }
}

