/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security.common.spring;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class ChooseObjectFactoryBean
extends AbstractFactoryBean {
    private static final char SEPARATOR_CHAR = ',';
    private String testValue;
    private Map casesMap;
    private Object defaultObject = null;

    protected Object createInstance() throws IllegalStateException, Exception {
        Object instance = this.findMatch(this.testValue);
        if (instance == null) {
            throw new IllegalStateException("Unable to find find match for '" + this.testValue + "'");
        }
        return instance;
    }

    private Object findMatch(String operator) throws IllegalStateException {
        Object resultCase = null;
        if (this.casesMap != null && operator != null) {
            for (String key : this.casesMap.keySet()) {
                String[] splitKeys = StringUtils.split((String)key, (char)',');
                for (int i = 0; i < splitKeys.length; ++i) {
                    String splitKey = splitKeys[i];
                    if (!operator.matches(splitKey)) continue;
                    if (resultCase != null) {
                        throw new IllegalStateException("More than single case findMatch with '" + operator + "', casesMap: " + this.casesMap);
                    }
                    resultCase = this.casesMap.get(key);
                }
            }
        }
        if (resultCase == null) {
            resultCase = this.defaultObject;
        }
        return resultCase;
    }

    public Class getObjectType() throws IllegalStateException {
        Object match = this.findMatch(this.testValue);
        if (match != null) {
            return match.getClass();
        }
        return null;
    }

    public void setCasesMap(Map casesMap) {
        this.casesMap = casesMap;
    }

    public void setDefaultObject(Object defaultObject) {
        this.defaultObject = defaultObject;
    }

    public void setTestValue(String testValue) {
        this.testValue = testValue;
    }
}

