/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security.common.spring.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class DbUnitDatabasePopulator
implements InitializingBean {
    private static final Log log = LogFactory.getLog(DbUnitDatabasePopulator.class);
    private Resource[] locations;
    private DataSource dataSource;
    private boolean enabled = true;
    private boolean ordered = true;
    private IDataTypeFactory dataTypeFactory = null;
    private String dbSchema = null;
    private DatabaseOperation databaseOperation = DatabaseOperation.CLEAN_INSERT;

    public void afterPropertiesSet() throws Exception {
        if (this.enabled) {
            log.info((Object)"DbUnitDatabasePopulator is enabled");
            this.populateDatabase();
        } else {
            log.info((Object)"DbUnitDatabasePopulator is disabled");
        }
    }

    private void commitIfNecessary(Connection connection) throws SQLException {
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    private DatabaseConnection createDbUnitConnection(Connection connection) {
        DatabaseConnection databaseConnection = !StringUtils.isEmpty((String)this.dbSchema) ? new DatabaseConnection(connection, this.dbSchema) : new DatabaseConnection(connection);
        if (this.dataTypeFactory != null) {
            log.debug((Object)("Using " + this.dataTypeFactory));
            DatabaseConfig config = databaseConnection.getConfig();
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)this.dataTypeFactory);
        }
        return databaseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(Resource resource) throws IOException, SQLException, DatabaseUnitException {
        Connection connection = this.dataSource.getConnection();
        DatabaseConnection databaseConnection = this.createDbUnitConnection(connection);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading data from " + resource.getFilename()));
            }
            FlatXmlDataSet dataSet = new FlatXmlDataSet(resource.getInputStream());
            if (this.ordered) {
                dataSet = new FilteredDataSet((ITableFilter)new DatabaseSequenceFilter((IDatabaseConnection)databaseConnection), (IDataSet)dataSet);
            }
            dataSet = new ReplacementDataSet((IDataSet)dataSet);
            ((ReplacementDataSet)dataSet).addReplacementObject((Object)"[null]", null);
            DatabaseOperation.INSERT.execute((IDatabaseConnection)databaseConnection, (IDataSet)dataSet);
            this.commitIfNecessary(connection);
        }
        finally {
            databaseConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDatabase() throws Exception {
        IDataSet[] dataSets = new IDataSet[this.locations.length];
        for (int i = 0; i < this.locations.length; ++i) {
            Resource res = this.locations[i];
            log.info((Object)("Loading data from " + res.getFilename()));
            dataSets[i] = new FlatXmlDataSet(res.getInputStream());
        }
        CompositeDataSet dataSet = new CompositeDataSet(dataSets);
        Connection connection = this.dataSource.getConnection();
        DatabaseConnection databaseConnection = this.createDbUnitConnection(connection);
        try {
            if (this.ordered) {
                dataSet = new FilteredDataSet((ITableFilter)new DatabaseSequenceFilter((IDatabaseConnection)databaseConnection), (IDataSet)dataSet);
            }
            dataSet = new ReplacementDataSet((IDataSet)dataSet);
            ((ReplacementDataSet)dataSet).addReplacementObject((Object)"[null]", null);
            this.databaseOperation.execute((IDatabaseConnection)databaseConnection, (IDataSet)dataSet);
            this.commitIfNecessary(connection);
        }
        finally {
            databaseConnection.close();
        }
    }

    public void setDatabaseOperation(DatabaseOperation databaseOperation) {
        this.databaseOperation = databaseOperation;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataTypeFactory(IDataTypeFactory dataTypeFactory) {
        this.dataTypeFactory = dataTypeFactory;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }
}

