/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security.common.spring.db;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.Server;
import org.hsqldb.ServerConfiguration;
import org.hsqldb.persist.HsqlProperties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class HsqlServerBean
implements InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog(HsqlServerBean.class);
    private Properties serverProperties;
    private boolean enabled = true;
    private Server server;

    public void afterPropertiesSet() throws Exception {
        if (!this.enabled) {
            log.debug((Object)"HsqlServerBean is disabled, so HSQLDB will not be started");
            return;
        }
        HsqlProperties configProps = new HsqlProperties(this.serverProperties);
        ServerConfiguration.translateDefaultDatabaseProperty((HsqlProperties)configProps);
        this.server = new Server();
        this.server.setRestartOnShutdown(false);
        this.server.setNoSystemExit(true);
        this.server.setProperties(configProps);
        log.info((Object)"HSQL Server Startup sequence initiated");
        this.server.start();
        log.info((Object)("HSQL Server started on " + this.server.getAddress()));
    }

    public void destroy() {
        if (!this.enabled) {
            return;
        }
        log.info((Object)"HSQL Server Shutdown sequence initiated");
        this.server.signalCloseAllServerConnections();
        this.server.shutdown();
        this.server = null;
        log.info((Object)"HSQL Server stopped");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setServerProperties(Properties serverProperties) {
        this.serverProperties = serverProperties;
    }
}

