/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security.none.authentication;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.openl.commons.web.util.WebTool;
import org.openl.rules.security.none.SimpleAuthenticationToken;

public class AuthenticationFilter
implements Filter {
    private static GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ADMIN")};

    private static String nameFromRequest(ServletRequest req) {
        if (WebTool.isLocalRequest((ServletRequest)req)) {
            return "LOCAL";
        }
        return req.getRemoteAddr();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        Object authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            authentication = new SimpleAuthenticationToken(authorities, AuthenticationFilter.nameFromRequest(req));
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        chain.doFilter(req, resp);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

